﻿Clear-Host

#Path to spec files, e.g. Lotlist.txt & Sources.txt
$SpecPath = "G:\BEKDocs\Scripts"

#Load contents of text file file into array LotList - one lot per line
$LotList     = Get-Content -Path "$($SpecPath)\LotList.txt"

#Load contents of text file file into array Sources - one lot per line
$Sources     = Get-Content -Path "$($SpecPath)\Sources.txt"

#Where to put copies of selected files
$Destination = "G:\BEKDocs\Transfer"

ForEach ( $Src in $Sources) {               #Loop through Sources Array

   ForEach ( $Val in $LotList) {            #Loop through LotList Array

      Get-Childitem $Src |                  #Get files in $Src
      Select Name, FullName |               #Select only necessary properties from object
      Where-Object Name -Match "$($Val)" |  #Select only items matching item in LotList
         ForEach-Object {                   #Loop through matching files and copy
               Copy-Item -Path $_.FullName `
                         -Destination "$($Destination)\$($_.Name)" -Force
         } #End ForEach-Object

   }  #End ForEach ($Val

} #End ForEach ($Src