﻿<#
 +--------------------------------------------------------+
 | Computer Mentors System Information Dialog V11.00      |
 | Code adapted from:                                     |
 |          Powershell PC Info Script V1.0b               | 
 |             Coded By:Trenton Ivey(kno)                 | 
 |                    hackyeah.com                        |
 | Incorporated Coding changes recommed by Cafed00d @ WSL |
 |                                                        |
 | Updated: 09/03/15 Single GenerateTab Function with     |
 |                   proper argument passing syntax!      |
 |          09/10/15 Added new information & fixed format |
 |                   of some output                       | 
 |          09/14/15 Fixed Monitor reporting problem      |
 |          10/23/15 Added check for Administrator Priv.  |
 |          10/25/15 Expanded Storage Information         |
 |          10/28/15 Added physical drive information     |
 |          10/29/15 Get-Drives & Combine-Object Functs   |
 |          11/21/15 Added Win10 Telemetry Service        |
 |          12/15/15 Added Write to file option button    |
 +--------------------------------------------------------+
#>

param (
  $compname = $env:COMPUTERNAME  #Default if no Compname Arg.
)

$PGMVersion = 11.00   #--- Remember to Update! ----
Add-Type -AssemblyName  System.Windows.Forms
Add-Type -AssemblyName  System.Drawing

function GenerateForm {

#---------------------- Form Objects     ----------------------------
$CMsForm        = New-Object -TypeName System.Windows.Forms.Form
$statusBar1     = New-Object -TypeName System.Windows.Forms.StatusBar
$lblMainTitle   = New-Object -TypeName System.Windows.Forms.Label
$btnExit        = New-Object -TypeName System.Windows.Forms.Button
$btnWriteFile   = New-Object -TypeName System.Windows.Forms.Button
$MainTabControl = New-Object -TypeName System.Windows.Forms.TabControl

#---------------------- End Form Objects -----------------------------

#----------------------------------------------------------------------
#                     Event Handler Script Blocks
#----------------------------------------------------------------------

$btnWriteFile_OnClick=
{
 
   $InfoFileName = "$([environment]::getfolderpath("mydocuments"))\PCInfo.txt"

   $tboxHardware.Text   +
   $tboxWindows.Text    +
   $tboxVideo.Text      +
   $tboxStorage.Text    +
   $tboxNetwork.Text    +
   $tboxPrinters.Text   +
   $tboxDrivers.Text    +
   $tboxInstPgms.Text   +
   $tboxServices.Text    > "$InfoFileName"

   $StatusBar1.text = "Data written to: $($InfoFileName)"
   $btnWriteFile.Visible = $False

} #End $btnWriteFile_OnClick

$btnExit_OnClick=
{
 $CMsForm.Close()
}

$OnLoadForm_StateCorrection=
{
  #  Correct the initial state of the form to prevent the 
  #  .Net maximized form issue
$CMsForm.WindowState = $IntFrmWinState
}

#---------------------- End Event Handler Script Blocks ---------------------

#------------ Main Form ------------------

#--- Form Drawing References ---

$Form_Width       = 1050
$Form_Height      = 600
$MainTitleHeight  =  35   
$StatusBar_Height =  25
$ExitBtn_Height   =  30
$tabWidth         = $Form_Width-20
$tabHeight        = $Form_Height - $StatusBar_Height + $MainTitleHeight + 20
$tabSize          = New-Object -TypeName System.Drawing.Size(
                                              $tabWidth,$tabHeight)
$tabLocation      = New-Object -TypeName System.Drawing.point(4,22)
$tboxWidth        = $tabWidth-20
$tboxHeight       = 430
$tboxFont         = New-Object -TypeName System.Drawing.Font(
                                             "Courier New",20,1,0)
$tboxSize         = New-Object -TypeName System.Drawing.Size(
                                              $tboxWidth,$tboxHeight)
$tboxLocation     = New-Object -TypeName System.Drawing.Point(10,10)
$tboxForeColor    = [Drawing.Color]::Yellow
$tboxBackColor    = [Drawing.Color]::Blue

$System_Windows_Forms_Padding = New-Object -TypeName System.Windows.Forms.Padding
$System_Windows_Forms_Padding.All = 0

$CMsForm.ClientSize      = New-Object -TypeName System.Drawing.Size($(
                                     $Form_Width),$($Form_Height))
$CMsForm.Name            = "CMsForm"
$CMsForm.Text            =`
              "Computer Mentor's Computer Information Version $PGMVersion " +
              "Running with $(Get-AdminStatus) privledges"

$CMsForm.BackColor       = [Drawing.Color]::DarkGray
$CMsForm.ForeColor       = [Drawing.Color]::White
$CMsForm.StartPosition   = 
                    [System.Windows.Forms.FormStartPosition]::CenterScreen
$CMsForm.FormBorderStyle = [System.Windows.Forms.FormBorderStyle]::Fixed3D
$CMsForm.ControlBox      = $False

# --- Status Bar ---

$statusBar1.Name     = "statusBar1"
$statusBar1.Location = New-Object -TypeName System.Drawing.Point($(
                                         $Form_Height-$StatusBar_Height),0)
$statusBar1.Size     = New-Object -TypeName System.Drawing.Size($(
                                        $Form_Width-40),$($StatusBar_Height))
$statusBar1.Font      = New-Object -TypeName System.Drawing.Font(
                                                          "Verdana",14,1,0) 
$statusBar1.TabIndex = 8
$statusBar1.Text     = "Ready"

$CMsForm.Controls.Add($statusBar1)

#------------- Main Title -------------

$lblMainTitle.Name      = "lblMainTitle"
$lblMainTitle.Location  = New-Object -TypeName System.Drawing.Point(20,15)
$lblMainTitle.Size      = New-Object -TypeName System.Drawing.Size($(
                                                       $Form_Width-40),35)
$lblMainTitle.TextAlign = 'MiddleCenter'
$lblMainTitle.TabIndex  = 7
$lblMainTitle.Text      = "Computer Information"
$lblMainTitle.Font      = New-Object -TypeName System.Drawing.Font(
                                                          "Verdana",26,1,0) 
$lblMainTitle.BackColor = [Drawing.Color]::DarkGray
$lblMainTitle.ForeColor = [Drawing.Color]::Blue

$CMsForm.Controls.Add($lblMainTitle)

#------------  WriteFile Button ----------------

$btnWriteFile.Name      = "btnExit"
$btnWriteFile.Location  = New-Object -TypeName System.Drawing.Point(10,
                       $($Form_Height - $StatusBar_Height - $ExitBtn_Height))
$btnWriteFile.Size      = New-Object -TypeName System.Drawing.Size(185,35)
$btnWriteFile.TabIndex  = 6
$btnWriteFile.Text      = "Write to File"
$btnWriteFile.BackColor = [Drawing.Color]::Green
$btnWriteFile.ForeColor = [Drawing.Color]::White
$btnWriteFile.Font      = $tboxFont

$btnWriteFile.add_Click($btnWriteFile_OnClick)
$CMsForm.Controls.Add($btnWriteFile)

#------------  Exit Button ----------------

$btnExit.Name      = "btnExit"
$btnExit.Location  = New-Object -TypeName System.Drawing.Point($(
                                                           $Form_Width-80),
                       $($Form_Height - $StatusBar_Height - $ExitBtn_Height))
$btnExit.Size      = New-Object -TypeName System.Drawing.Size(75,35)
$btnExit.TabIndex  = 6
$btnExit.Text      = "Exit"
$btnExit.BackColor = [Drawing.Color]::Red
$btnExit.ForeColor = [Drawing.Color]::White
$btnExit.Font      = $tboxFont

$btnExit.add_Click($btnExit_OnClick)
$CMsForm.Controls.Add($btnExit)

#----------- Main Tab Control ---------------------

$MainTabControl.Name       = "MainTabControl"
$MainTabControl.Location   = New-Object -TypeName System.Drawing.Point(10,60)
$MainTabControl.Size       = New-Object -TypeName System.Drawing.Size($(
                                   $Form_Width-20), $($Form_Height - 
                                   $StatusBar_Height - 90))
$MainTabControl.ShowToolTips  = $True
$MainTabControl.TabIndex      = 4
$MainTabControl.Font          =  New-Object `
                                -TypeName System.Drawing.Font("Tahoma",20,2,0)

$CMsForm.Controls.Add($MainTabControl)

#-------------- Hardware Tab ---------------------------

  $fmt = @{Expression={$_.Item};Label="Item  ";width=25},
         @{Expression={$_.Value};Label="Value";Width=40}

  $HWInfo = $CITable.Rows[0..$($OSTabStartCnt-1)] | 
                    Format-Table -Property $fmt | Out-String

#Memory Info 

  $fmtMEM = @{Expression={$_.DeviceLocator.Trim('DIMM')};
                             Label="MB`nSlot";width=4},
            @{Expression={$_.InterleavePosition};Label="Bank`nPos";Width=4},
            @{Expression={$_.Speed};Label="`nSpeed";width=6},
            @{Expression={$_.DataWidth};Label="Data`nWidth";width=5},
            @{Expression={'{0:#.00}' -f ($_.Capacity/1gb)}; 
                           Label="Size`n/ GB";width=5;align='right'},
            @{Expression={$_.Manufacturer};Label="`nManufacturer";Width=15},
            @{Expression={$_.SerialNumber};Label="`nSerial No.";width=10}

  $MemoryInfo   = get-WMIObject -Computer $compname `
                                -Class Win32_PhysicalMemory | 
                  Sort-Object  -Property {$_.DeviceLocator} | 
                  Format-Table -Property $fmtMEM | Out-String

  $MemTitle     =  "Memory Information:`n`n" | Out-String

  $tabHardware  = New-Object -TypeName System.Windows.Forms.TabPage
  $tboxHardware = New-Object -TypeName System.Windows.Forms.Textbox

  GenerateTab ([ref]$tabHardware) ([ref]$tboxHardware) ('Hardware') `
              ('Computer, BIOS/UEFI, Processor, Memory')

  $tboxHardware.Text = $HWInfo + $MemTitle + $MemoryInfo

#------------------------------- Windows Tab -----------------------------

  $WinInfo = $citable.rows[$OSTabStartCnt..$OSTabEndCnt] | 
               Format-Table -Property $fmt | Out-String

  #User Account Information

  $fmtAcct = @{Expression={$_.Name};Label="`nUserID";width=16},
             @{Expression={$_.Domain};
                Label="Domain/`nWorkGroup";Width=16},
             @{Expression={If ($_.Disabled) {'Disabled'} ELse {'Enabled'}};
                Label="`nStatus";align='left';width=8},
             @{Expression={If ($_.PasswordRequired) {'   Yes'} 
                                               ELse {'   No'}};
                Label="|----P A`nRequired";align='left';Width=8},
             @{Expression={If ($_.PasswordExpires) {'  Yes'} ELse {'  No'}};
                Label="S S W O`nExpires";align='left';width=7},
             @{Expression={If ($_.PasswordChangeable) {'   Yes'} 
                           ELse {'   No'}};
                Label="R D S---|`nChangable";align='left';Width=9}

  $uai    = Get-UserAccounts | Format-Table -Property $fmtAcct | Out-String
  $UATitle          = "User Account Info`n`n" | Out-String

  $tabWindows       = New-Object -TypeName System.Windows.Forms.TabPage
  $tboxWindows      = New-Object -TypeName System.Windows.Forms.Textbox

  GenerateTab ([ref]$tabWindows) ([ref]$tboxWindows) ('Windows') `
              ('Windows, Security S/W, PowerShell, .Net, User Accts.') 

  $tboxWindows.Text = $WinInfo + $UATitle +  $uai

#------------------- Video Tab ----------------------------------
 
  $monfmt  = @{Expression={$_.Name};Label="Monitor Name";width=25},
             @{Expression={$_.Manufacturer};Label="Manufacturer";Width=15},
             @{Expression={$_.SerialNo};Label="Serial Number";width=15},
             @{Expression={$_.HardWareID};Label="Registry ID";width=15}

  $VideoHW    = $citable.rows[$VideoTabStartCnt..$VideoTabEndCnt] | 
                  Format-Table -Property $fmt | Out-String

  $MonTitle   = "Monitor Information:`n`n" | Out-String 

  $MonInfo = $mons | Format-Table -Property $monfmt | Out-String

  $tabVideo       = New-Object -TypeName System.Windows.Forms.TabPage
  $tboxVideo      = New-Object -TypeName System.Windows.Forms.Textbox

  GenerateTab ([ref]$tabVideo) ([ref]$tboxVideo) ('Video') `
              ('Video Adapters, Resolutions, Monitors')

  $tboxVideo.Text = $VideoHW + $MonTitle + $MonInfo

#--------------------------- Storage Tab ----------------------------------

 #Physical Drive Info
 
  $PhyDiskFmt = @{Expression={$_.Name.trim('\\.\PHYSICALDRIVE')};
                  Label="Drv`n No";Width=3;Align='Right'},
                @{Expression={$_.Caption};Label="`nName";width=25},
                @{Expression={$_.Model -Match 'SSD'};Label="`nSSD";
                                                      Width=5;Align='left'},
                @{Expression={$_.SerialNumber.trim()};Label="`nSerial Number";
                                                     Width=20;Align='left'},
                @{Expression={ '{0:#,000.00}' -f ($_.Size/1gb)}; 
                            Label="Disk Size`n / GB";width=9;align='right'},
                @{Expression={$_.Partitions};Label="`n#Parts";Width=6}

  $PhyDiskTitle = "Physical Disk Information:" | Out-String

  $PhyDiskInfo = get-WMIObject -Computer $compname -Class Win32_diskdrive | 
                 Where-Object {$_.size -ge 0 }  | Sort-Object -Property Name |
                 Format-Table -Property $PhyDiskFmt | Out-String

 
 #Logical Drive Info

  $DiskTypeHash = @{
   2="Removable"
   3="Fixed"
   4="Network"
   5="Compact"}

   $DiskFmt = @{Expression={$_.Name};Label="Drive`nLetter";width=6},
             @{Expression={$_.VolumeName};Label="Volume`nName";Width=10},
             @{Expression={$_.filesystem};Label="File`nSystem";Width=6},
             @{Expression={$DiskTypeHash.item([int]$_.DriveType)};
               Label="Drive`nType";width=9},
             @{Expression={$_.compressed};Label="`nCompressed";Width=10;
                                          Align='left'},
             @{Expression={ '{0:#,000.00}' -f ($_.Size/1gb)}; 
               Label="Disk Size`n / GB";width=9;align='right'},
             @{Expression={ '{0:#,000.00}' -f ($_.FreeSpace/1gb)}; 
               Label="Free Space`n / GB";width=10;align='right'},
             @{Expression={$_.DiskIndex};Label="Drv`nNo";Width=4},
             @{Expression={$_.Bootable};Label="`nBoot";Width=5;Align='left'}

  $DiskInfoTitle = "Logical Disk Information:" | Out-String

  $DiskInfo = Get-Drives | Sort-Object  -Property DiskIndex, Name | 
                           Format-Table -Property $DiskFmt | Out-String 

#CD/DVD Info

  $CDTitle  = "CD/DVD Information:`n`n" | Out-String
  $CD       = Get-WmiObject -Class Win32_CDROMDrive -ComputerName $compname 

  If ($CD -ne $null) {

    $CDfmt     = @{Expression={$_.Drive};Label="Drive Letter";width=6},
                 @{Expression={$_.Name};Label="`nName";Width=25},
                 @{Expression={$_.CapabilityDescriptions};
                   Label="`nCapabilities";width=40}

    $CDDVDINFO = $CD |  Format-Table -Wrap -Property $CDfmt | Out-String 
  }
  Else{
    $CDDVDINFO = "None-Avaliable" | Out-String
  }

  #Mapped Drives Info

  $MDriveTitle = "Mapped Drive Information:" | Out-String

  $MappedDrives = get-WMIObject -class Win32_MappedLogicalDisk `
                                -computer $compname | 
       Where-Object {$_.size -ge 0 -and $_.ProviderName -ne $null } 

If ($MappedDrives -eq $Null) {

    $MDriveInfo = @"
    
    --No Mapped Drives--

    If drives were mapped using standard user privileges, even from an
    administrator account, they will not show up if this script is run
    as Administrator!
"@
  } #End If ($MappedDrives...)
  Else {
        $fmtMDR = @{Expression={$_.Name};Label="Drive`nLetter";width=6},
                  @{Expression={$_.Compressed};Label="Compressed";Width=5},
                  @{Expression={$_.ProviderName};Label="Provider";Width=50},
                  @{Expression={ '{0:#,000.00}' -f ($_.Size/1gb)}; 
                      Label="Disk Size`n / GB";width=9;align='right';}

        $MDriveInfo = $MappedDrives| Format-Table -Property $fmtMDR | 
                                     Out-String

  } #End Else ($MappedDrives...)

#Shares Info

  $fmtShare   = @{Expression={$_.Name};Label="`nShare Name";width=12},
                @{Expression={$_.PSComputerName};Label="`nComputer Name";
                                                 Width=15},
                @{Expression={$_.MaximumAllowed};Label="Max`nUsers";
                                                 Width=5;align='Left'},
                @{Expression={$_.Path};Label="`nPath";Width=35}

  $ShareTitle = "Share Information:" | Out-String

  $ShareInfo  = Get-WmiObject -Class Win32_Share -ComputerName $compname |
                Where-Object {$_.Type -eq 0} | Sort-Object -Property Name |
                Format-Table -Property $fmtShare | Out-String

  $tabStorage       = New-Object -TypeName System.Windows.Forms.TabPage
  $tboxStorage      = New-Object -TypeName System.Windows.Forms.Textbox

  GenerateTab ([ref]$tabStorage) ([ref]$tboxStorage) ('Storage') `
              ('Drives, CD/DVD/BlueRay, Mapped Drives, Shares')

  $tboxStorage.Text = $PhyDiskTitle  + $PhyDiskInfo + 
                      $DiskInfoTitle + $DiskInfo    + 
                      $CDtitle       + $CDDVDINFO   + 
                      $ShareTitle    + $ShareInfo   + 
                      $MDriveTitle   + $MDriveInfo

#----------------------------- Network Tab -------------------------------

  $netfmt = @{Expression={$_.Name};Label="`nName";Width=18},
            @{Expression={$_.Status};Label="`nStatus";Width=12},
            @{Expression={ '{0:#,000}' -f ($_.Speed/1000000)}; 
                                     Label="Speed`n / MB"; 
                                     Width=5;Align='right'}, 
            @{Expression={$_.InterfaceDescription}; 
                                     Label="`nAdapter Name";Width=40}

  $NetIPFmt = @{Expression={$_.InterfaceAlias};Label='Interface';  Width=10},
              @{Expression={$_.AddressFamily}; Label='IP Width';   Width= 7},
              @{Expression={$_.IPAddress};     Label='IP Address'; Width=30}

  $IPInfo = Get-NetIPAddress -ErrorAction SilentlyContinue `
                             -InterfaceAlias "Ethernet","Wi-Fi" | 
            Sort-Object  -Property InterfaceAlias, AddressFamily | 
            Format-Table -Property $NetIPFmt | Out-String

  $NetInfo = Get-NetAdapter -Name * | 
               Format-Table -Property $netfmt | Out-String

  $tabNetwork  = New-Object -TypeName System.Windows.Forms.TabPage
  $tboxNetwork = New-Object -TypeName System.Windows.Forms.Textbox
 
  GenerateTab ([ref]$tabNetwork) ([ref]$tboxNetwork) ('Network') `
              ('Status of Network Adapters (NICs)')

  $tboxNetwork.Text = "$NetInfo $IPInfo"

#------------------------ End Network Tab ---------------------------------

#-------------------------- Printers Tab ----------------------------------

  $ptrfmt = @{Expression={$_.DeviceID};  Label="Printer";Width=34},
            @{Expression={$_.DriverName};Label="Driver"; Width=24},
            @{Expression={$_.PortName};  Label="Port";   Width=20}

  $tabPrinters       = New-Object -TypeName System.Windows.Forms.TabPage
  $tboxPrinters      = New-Object -TypeName System.Windows.Forms.Textbox

  GenerateTab ([ref]$tabPrinters) ([ref]$tboxPrinters) ("Printers")

  $tboxPrinters.Text = 
          get-WMIObject  -Computer $compname -Class Win32_Printer |
           Select-Object -Property DeviceID,DriverName, PortName | 
           Sort-Object   -Property DeviceId | 
           Format-Table  -Property $ptrfmt  | Out-String

#---------------------- End Printers Tab ---------------------------------

#---------------------- Drivers Tab      ---------------------------------

  $fmt = @{Expression={$_.DeviceName};Label="Driver Description";Width=40},
         @{Expression={$_.DriverVersion};Label="Version Number";Width=35}

  $DrvTitle    = "Non-Windows Unique Drivers and Version Numbers:`n`n" | 
                   Out-String

  $DriverInfo  = Get-WmiObject -Computer $compname `
                               -Class Win32_PNPSignedDriver | 
                 Where-Object  -Property DriverVersion -notlike `
                               -Value "*.?.????*.*" |
                 Where-Object  -Property DeviceName -ne -Value $Null | 
                 Sort-Object   -Property DeviceName -Unique | 
                 Format-Table  -Property $fmt | Out-String

  $tabDrivers  = New-Object -TypeName System.Windows.Forms.TabPage
  $tboxDrivers = New-Object -TypeName System.Windows.Forms.Textbox

  GenerateTab ([ref]$tabDrivers) ([ref]$tboxDrivers) ("Drivers")

  $tboxDrivers.Text = $DrvTitle + $DriverInfo

#---------------------- End Drivers Tab  ---------------------------------

#----------------------  Programs Tab    ---------------------------------

  $fmtPgms = @{Expression={$_.DisplayName};Label="Program Name";width=30},
             @{Expression={$_.InstallDate};Label="Installed";width=9},
             @{Expression={$_.InstallLocation};Label="Install Path";width=39}

if (!([Diagnostics.Process]::GetCurrentProcess().Path -match '\\syswow64\\'))
{
  $unistallPath = "\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\"
  $unistallWow6432Path = 
    "\SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\"

  $PgmsInfo =
  @(
    if (Test-Path   -Path "HKLM:$unistallWow6432Path" ) { 
      Get-ChildItem -Path "HKLM:$unistallWow6432Path"}
    if (Test-Path   -Path "HKLM:$unistallPath" ) { 
      Get-ChildItem -Path "HKLM:$unistallPath" }
    if (Test-Path   -Path "HKCU:$unistallWow6432Path") { 
      Get-ChildItem -Path "HKCU:$unistallWow6432Path"}
    if (Test-Path   -Path "HKCU:$unistallPath" ) { 
      Get-ChildItem -Path "HKCU:$unistallPath" }
   ) |
   Where-Object {
     $_.GetValue('DisplayName') -and 
    ($_.GetValue('UninstallString') -or 
     $_.GetValue('NoRemove')) -and 
    !$_.GetValue('SystemComponent') -and 
    !$_.GetValue('ReleaseType') -and 
    !$_.GetValue('ParentKeyName')
  } |
    Get-ItemProperty |  Sort-Object -Property DisplayName |
    Select-Object -Property DisplayName,InstallDate,InstallLocation | 
    Format-Table  -Property $fmtPgms | Out-String 
}
else
{
  $PgmsInfo =
    "You are running 32-bit Powershell on 64-bit system.`n" +
    "Please run 64-bit Powershell instead." | Out-String
}

  $tabInstPgms    = New-Object -TypeName System.Windows.Forms.TabPage
  $tboxInstPgms   = New-Object -TypeName System.Windows.Forms.Textbox

  GenerateTab ([ref]$tabInstPgms) ([ref]$tboxInstPgms) ("Installed Programs")

  $tboxInstPgms.Text = $PgmsInfo

#---------------------- End Programs Tab ---------------------------------

#---------------------- Registry/Services Tab  ------------------------------

  $fmtServices    = @{Expression={$_.Item};Label="Item";width=60},
                    @{Expression={$_.Value};Label="Value";Width=20}

  $ServicesInfo   = $CITable.Rows[$ServicesTabStartCnt..$ServicesTabEndCnt] | 
                       Select-Object -Property Item,Value   | 
                       Format-Table  -Property $fmtServices | Out-String
                        
  $tabServices    = New-Object -TypeName System.Windows.Forms.TabPage
  $tboxServices   = New-Object -TypeName System.Windows.Forms.Textbox

  GenerateTab ([ref]$tabServices) ([ref]$tboxServices) ('Registry/Services') `
    ('Registry/Services...Hibernate, HyperBoot, and Homegroup, MalwareBytes')

  $tboxServices.Text = $ServicesInfo

#---------------------- End Services Tab ---------------------------------

#---------------------- End Form Code ------------------------------------

  #Save the initial state of the form
  $IntFrmWinState = $CMsForm.WindowState
  #Init the OnLoad event to correct the initial state of the form
  $CMsForm.add_Load($OnLoadForm_StateCorrection)

  #Show the Form
  $CMsForm.ShowDialog() | Out-Null

} #----------------- End Function GenerateForm ---------------------------

function GenerateTab {

 param ( 
         [Parameter(Mandatory=$True)]
          [System.Windows.Forms.TabPage] $tabObjectName,
         [Parameter(Mandatory=$True)]
          [System.Windows.Forms.Textbox] $tboxObjectName,
         [Parameter(Mandatory=$True)]
          [string] $tabName,
         [Parameter(Mandatory=$False)]
          [string] $TipText
        )

  $tabObjectName.Name          = "$tabName"
  $tabObjectName.Location      = $tabLocation
  $tabObjectName.Padding       = $System_Windows_Forms_Padding
  $tabObjectName.Size          = $tabSize  
  $tabObjectName.TabIndex      = 0
  $tabObjectName.Text          = $TabName
  If ($TipText -ne $null) {
    $tabObjectName.ToolTipText = $TipText
  }

  $tabObjectName.DataBindings.DefaultDataSourceUpdateMode = 0
  $tabObjectName.UseVisualStyleBackColor = $True

  $tboxObjectName.Location   = $tboxLocation 
  $tboxObjectName.Size       = $tboxSize
  $tboxObjectName.MultiLine  = $True
  $tboxObjectName.ForeColor  = $tboxForeColor
  $tboxObjectName.BackColor  = $tboxBackColor
  $tboxObjectName.ScrollBars = 'Both'
  $tboxObjectName.Font       = $tboxFont
  $tboxObjectName.ReadOnly   = $True

  $MainTabControl.Controls.Add($tabObjectName)
  $tabObjectName.Controls.add($tboxObjectName)

}   #---------------------- End GenerateTab ------------------------------

function Add-Row {

  param (
         [string]$ItemName,
         [string]$ItemValue
        ) 
  
      $CITRow = $CITable.NewRow()   #Create Row Variable
      $CITRow.Item = $ItemName      #Assign items to row variable
      $CITRow.Value = $ItemValue
      $CITable.Rows.Add($CITRow)    #Add Row to Table using Row Variable

}  #------------------ End Function Add-Row ------------------------------

function Combine-Object {
	
  param(
	 [Parameter(Mandatory=$True)] $object1,
	 [Parameter(Mandatory=$True)] $object2
	)

#	 Courtesy of: http://powershell.com/cs/media/p/7924.aspx

	$propertylistObj1 = @($object1 | Get-Member -ea Stop -memberType *Property | 
                                     Select-Object -ExpandProperty Name)
	$propertylistObj2 = @($object2 | Get-Member -memberType *Property | 
                                     Select-Object -ExpandProperty Name | 
                                     Where-Object { $_ -notlike '__*'})

	$propertylistObj2 | ForEach-Object {
		if ($propertyListObj1 -contains $_) {
			$name = '_{0}' -f $_
		} 
        else {
			$name = $_
		}

		$object1 = $object1 | Add-Member -NotePropertyName $name `
                                         -NotePropertyValue ($object2.$_) `
                                         -PassThru
	}

	Return ,$object1

} #----------------- End Function Combine-Object -----------------------------

function Get-Drives {

#	 Courtesy of: http://powershell.com/cs/media/p/7924.aspx

	Get-WmiObject -computer $compname -Class Win32_DiskPartition |
	ForEach-Object {
		$partition = $_
		$logicaldisk = $partition.psbase.GetRelated('Win32_LogicalDisk')
		if ($logicaldisk -ne $null) {
			Combine-Object $logicaldisk $partition 
		}
	}  |  select-Object -Property Name, VolumeName, FileSystem, DriveType, 
                   Compressed, Size, FreeSpace, DiskIndex, Index, Bootable

  #Note: This returns the Select-Object output to the caller!

} #End Function Get-Drives


function Get-WindowsProductKey([string]$computer)
{
 $Reg = [WMIClass] ("\\" + $computer + "\root\default:StdRegProv")
 $values = [byte[]]($reg.getbinaryvalue(2147483650, 
           "SOFTWARE\Microsoft\Windows NT\CurrentVersion", 
           "DigitalProductId").uvalue)
 $lookup = [char[]]("B","C","D","F","G","H","J","K","M","P","Q","R", 
                    "T","V","W","X","Y","2","3","4","6","7","8","9")
 $keyStartIndex      = [int]52;
 $keyEndIndex        = [int]($keyStartIndex + 15);
 $decodeLength       = [int]29
 $decodeStringLength = [int]15
 $decodedChars       = New-Object char[] $decodeLength
 $hexPid             = New-Object System.Collections.ArrayList

 for ($i = $keyStartIndex; $i -le $keyEndIndex; $i++) { 
   [void]$hexPid.Add($values[$i]) 
 }

 for ( $i = $decodeLength - 1; $i -ge 0; $i--) {  
               
   if (($i + 1) % 6 -eq 0) {
     $decodedChars[$i] = '-'
   }
   else
   {
     $digitMapIndex = [int]0
     for ($j = $decodeStringLength - 1; $j -ge 0; $j--)
     {
      $byteValue = [int](($digitMapIndex * [int]256) -bor [byte]$hexPid[$j])
      $hexPid[$j] = [byte] ([math]::Floor($byteValue / 24))
      $digitMapIndex = $byteValue % 24
      $decodedChars[$i] = $lookup[$digitMapIndex]
     }
   }
 }   #End For ($i...)

 $WindowsKey = ''    
 $decodedChars | ForEach-Object { $WindowsKey+=$_}
 
 Return ,$WindowsKey

}  #End Function Get-WindowsProductKey

function Get-UserAccounts{

<#+--------------------------------------------------+
  | From CH 14 PowerShell and WMI by Richard Siddawy |
  +--------------------------------------------------+
#>
  [CmdletBinding()]
  param (
   [parameter(ValueFromPipeline=$true,
     ValueFromPipelineByPropertyName=$true)]
    [string]$computername="$env:COMPUTERNAME"
  )

  PROCESS{
   Get-WmiObject -Class Win32_UserAccount -ComputerName $computername |
     Select-Object -Property `
                   AccountType, Description, Disabled, Domain, FullName, 
                   InstallDate, LocalAccount, Lockout, Name, SID, SIDType,
                   PasswordChangeable, PasswordExpires, PasswordRequired
  } #End Process

}  #------------------  End Function Get-UserAccounts  ------------------

function Get-AntiVirus{

<#+--------------------------------------------------+
  | From CH 14 PowerShell and WMI by Richard Siddawy |
  +--------------------------------------------------+
#>
  [CmdletBinding()]
  param (
    [parameter(ValueFromPipeline=$true,
      ValueFromPipelineByPropertyName=$true)]
     [string]$computername="$env:COMPUTERNAME"
  )

  PROCESS{
   $os = Get-WmiObject -Class Win32_OperatingSystem `
                       -ComputerName $computername
 
   if ([int]$os.BuildNumber -ge 6001 ) {
     $av = Get-WmiObject -Namespace 'ROOT\SecurityCenter2' `
                         -Class AntiVirusProduct `
                         -ComputerName $computername
   }
   else {
         $av = Get-WmiObject -Namespace 'ROOT\SecurityCenter' `
            -Class AntiVirusProduct -ComputerName $computername
   }

   Return ,$av
 
  } #End Process

} #--------------- End Function Get-AntiVirus  ----------------------

Function Get-WindowsUpdateConfig {

<#+---------------------------------------------------------+
  | Thanks to James O'Niel for this one!                    |
  | http://blogs.technet.com/b/jamesone/archive/2009/01/27/ |
  |        managing-windows-update-with-powershell.aspx     |
  +---------------------------------------------------------+
#>

  $AUNotificationLevels= @{
    0="Not configured";
    1="Disabled" ; 
    2="Notify before download";
    3="Notify before installation"; 
    4="Scheduled installation"}

  $AUDays=@{
    0="Every Day";
    1="Every Sunday";
    2="Every Monday"; 
    3="Every Tuesday";
    4="Every Wednesday";
    5="Every Thursday"; 
    6="Every Friday"; 
    7="EverySaturday"}

  $AUSettings = (New-Object -com "Microsoft.Update.AutoUpdate").Settings

  $AUObj = New-Object -TypeName System.Object

  Add-Member -inputObject $AuObj `
             -MemberType NoteProperty `
             -Name "NotificationLevel" `
             -Value $AUNotificationLevels[$AUSettings.NotificationLevel]

  Add-Member -inputObject $AuObj `
             -MemberType NoteProperty `
             -Name "UpdateDays" `
             -Value $AUDays[$AUSettings.ScheduledInstallationDay]

  Add-Member -inputObject $AuObj `
             -MemberType NoteProperty `
             -Name "UpdateHour" `
             -Value $AUSettings.ScheduledInstallationTime 

  Add-Member -inputObject $AuObj `
             -MemberType NoteProperty `
             -Name "Recommended updates" `
             -Value $(If ($AUSettings.IncludeRecommendedUpdates) 
                      {"Included"}  else {"Excluded"})

  Return ,$AuObj

}  #---------- End Function Get-WindowsUpdateConfig -------------------------

  
#-------------------------------- Add a Helper ------------------------------

$showWindowAsync = Add-Type –memberDefinition @” 
[DllImport("user32.dll")] 
public static extern bool ShowWindowAsync(IntPtr hWnd, int nCmdShow); 
“@ -name “Win32ShowWindowAsync” -namespace Win32Functions –passThru

function Show-PowerShell() { 
     [void]$showWindowAsync::ShowWindowAsync(
                          (Get-Process –id $pid).MainWindowHandle, 10) 
}  #End Function Show-PowerShell

function Hide-PowerShell() { 
    [void]$showWindowAsync::ShowWindowAsync(
                          (Get-Process –id $pid).MainWindowHandle, 2) 
}  #End Function Hide-PowerShell

Function Get-AdminStatus {

    If (-NOT ([Security.Principal.WindowsPrincipal] `
          [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole(`
          [Security.Principal.WindowsBuiltInRole] "Administrator"))
    {"User"}
    Else
    {"Administrator"}
} # End Function Get-AdminStatus

<#
  +------------------------------------------------------------+
  |                        Main Program                        |
  +------------------------------------------------------------+
#>

Hide-Powershell       #--- Hide the CMD Window ---

$enclosureNames = (
  "unknown",  # 0
  "Other" ,
  "Unknown" ,
  "Desktop" ,
  "Low Profile Desktop" ,
  "Pizza Box" ,  #5
  "Mini Tower" ,
  "Tower" ,
  "Portable" ,
  "Laptop" ,
  "Notebook" , #10
  "Hand Held" ,
  "Docking Station" ,
  "All-in-One" ,
  "Sub Notebook" ,
  "Space Saving" ,  #15
  "Lunch Box" ,
  "Main System Chassis",
  "Expansion Chassis",
  "Sub-Chassis",
  "Bus Expansion Chassis", #20
  "Peripheral Chassis" ,
  "Storage Chassis" ,
  "Rack Mount Chassis" ,
  "Sealed-Case PC" #24
)
     
 Clear-Host

#General Computer Information   

# Create Table
  $CITable = New-Object -TypeName System.Data.DataTable "Computer Information"
#Create Columns for table 
  $CITcol1 = New-Object -TypeName System.Data.DataColumn Item,([string])       
  $CITcol2 = New-Object -TypeName System.Data.DataColumn Value,([string])
#Add Columns to table
  $CITable.columns.add($CITcol1)
  $CITable.columns.add($CITcol2)

  $ComputerSysObj = 
      get-WMIObject -computer $compname -Class Win32_ComputerSystem    

  Add-Row -ItemName 'Manufacturer'    -ItemValue $ComputerSysObj.Manufacturer 
  Add-Row -ItemName 'Model'           -ItemValue $ComputerSysObj.Model
  Add-Row -ItemName 'System Type'     -ItemValue $ComputerSysObj.SystemType        

  $enclosure = get-wmiobject -computer $compname `
                             -Class Win32_SystemEnclosure
  $ChassisNo = $enclosure.ChassisTypes[0]
  $ChassisName =  if ($ChassisNo -ge $enclosureNames.length) {
                         "Currently Unassigned"
                  } 
                  else {
                         $enclosureNames[$ChassisNo]
                  }

  Add-Row  -ItemName 'Enclosure' -ItemValue $ChassisName
  Add-Row  -ItemName ''

  $BIOSObject = get-WMIObject -computer $compname -Class Win32_BIOS
  Add-Row -ItemName 'BIOS Serial No'    -ItemValue $BIOSObject.SerialNumber
  Add-Row -ItemName '     Name'         -ItemValue $BIOSObject.Name
  Add-Row -ItemName '     Version' `
          -ItemValue $BIOSObject.SMBIOSBIOSVersion
  Add-Row -ItemName '     Date' `
          -ItemValue $BIOSObject.ReleaseDate.Substring(0,8)
  Add-Row -ItemName '     Manufacturer' -ItemValue $BIOSObject.Manufacturer

  $BV=Get-WmiObject -Class Win32_BIOS -NameSpace “root\CIMV2” | 
      Select-Object -Property BIOSVersion
  If ($BV.BIOSVersion[2] -ne $Null) {
    $Separator = "-"
    $BIOSManuf = $BV.BIOSVersion[2].split($Separator)   #BIOS Manufacturer
  Add-Row -ItemName '     Creator'      -ItemValue $BIOSManuf[0]
  }

  Add-Row -ItemName ''

  
  If ( "$(Get-AdminStatus)" -eq "Administrator") {
    $ErrorActionPreference = 'SilentlyContinue'
    $UEFISB = Confirm-SecureBootUEFI
    $ErrorActionPreference = 'Continue'

    if ($UEFISB -ne $null) {
      if ($UEFISB) {$UEFIStatus="On"} Else {$UEFIStatus="OFF"}
      Add-Row -ItemName 'Secure Boot UEFI' -ItemValue $UEFIStatus 
    }
    Else {
         Add-Row -ItemName 'Secure Boot UEFI' -ItemValue "Not Supported"
    }  
  }
  ELse {
         Add-Row -ItemName 'Secure Boot UEFI' `
                 -ItemValue "Requires Admin Access to verify!"
  } #End If (Get-AdminStatus...

  Add-Row -ItemName ''

  $CPU_Object = get-WMIObject -computer $compname -Class Win32_Processor

  Add-Row -ItemName 'Processor Name'   -ItemValue $CPU_Object.Name
  Add-Row -ItemName '  Info'           -ItemValue $CPU_Object.Caption
  Add-Row -ItemName '  Maker'          -ItemValue $CPU_Object.Manufacturer
  Add-Row -ItemName '  ID'             -ItemValue $CPU_Object.ProcessorID
  Add-Row -ItemName '  Physical Cores' -ItemValue $CPU_Object.NumberofCores
  Add-Row -ItemName '  Logical  Cores' -ItemValue `
                                        $CPU_Object.NumberofLogicalProcessors
  Add-Row -ItemName '  Address Width'  -ItemValue $CPU_Object.AddressWidth
  $HyperThreadingStatus = if ($CPU_Object.NumberOfCores -le 
                              $CPU_Object.NumberofLogicalProcessors) 
                              {'Enabled'} Else {'Disabled'}
         
  Add-Row -ItemName '  HyperThreading' -ItemValue $HyperThreadingStatus
  $VMFirmEnabled = if ($CPU_Object.VirtualizationFirmwareEnabled) 
                        {'Enabled'} Else {'DisAbled'}
  Add-Row -ItemName '  VM Firmware'    -ItemValue "$VMFirmEnabled"

#---------------------- End HardWare Tab Info ------------------------------

#---------------------- Windows Tab Information ----------------------------

  Get-CimClass -PropertyName version -QualifierName dynamic | Out-Null
  $CurOS          = Get-CimInstance -Class Win32_OperatingSystem
  $OSKey          = Get-WindowsProductKey $ComputerSysObj.name
  $OS_Object      = get-WMIObject -Class Win32_OperatingSystem `
                                  -computer $compname
  $LocalDateTime  = $OS_Object.ConvertToDateTime($OS_Object.LocalDateTime) 
  $LastBootUpTime = $OS_Object.ConvertToDateTime($OS_Object.LastBootUpTime)
  $UpTime         = @([String]($LocalDateTime - $LastBootUpTime))
  $SysRoot = Get-ChildItem  -Path Env:SystemRoot
  $UserProf = Get-ChildItem -Path Env:UserProfile

  $OSTabStartCNt = $CITable.Rows.Count
  Add-Row -ItemName 'OS Name'         -ItemValue $CurOS.Caption
  Add-Row -ItemName '   Version'      -ItemValue $CurOS.Version
  Add-Row -ItemName '   Bit-Width'    -ItemValue $CurOS.OSArchitecture
  Add-Row -ItemName '   Key'          -ItemValue $OSKey 
  Add-Row -ItemName '   System Root'  -ItemValue $SysRoot.Value
  Add-Row -ItemName '   Install Date' `
          -ItemValue $CurOS.InstallDate -f "mm/dd/yy" 
  Add-Row -ItemName '   Date/Time'    -ItemValue $LocalDateTime
  Add-Row -ItemName '   Last Boot'    -ItemValue $LastBootUpTime
  Add-Row -ItemName '   Up Time'      -ItemValue $UpTime.split('.')[0] 
  Add-Row -ItemName ' '               
  Add-Row -ItemName 'Computer Name'   -ItemValue $ComputerSysObj.Name 
  Add-Row -ItemName 'Current User ID' -ItemValue $ComputerSysObj.Username 
  Add-Row -ItemName 'User Profile'    -ItemValue $UserProf.Value
  Add-Row -ItemName 'Domain Name'     -ItemValue $ComputerSysObj.Domain 
  Add-Row -ItemName ' '               

  Add-Row -ItemName 'Security Software'
  $FWKey = "System\CurrentControlSet\Services\SharedAccess"
  $FWKey = "$FWKey\Parameters\FirewallPolicy\StandardProfile" 
  $FWallStatus = 
     [Microsoft.Win32.RegistryKey]::OpenRemoteBaseKey("LocalMachine",
     $env:COMPUTERNAME).OpenSubKey("$FWKey").GetValue("EnableFirewall")

  If ($FWallStatus -eq 1) {
    $FWallStatus = "On"
  }
  Else {
    $FWallStatus = "OFF"
  }

  Add-Row -ItemName "  Firewall"   -ItemValue $FWallStatus

  $AV = Get-AntiVirus
  Add-Row -ItemName '  AV Program' -ItemValue "$($AV.displayName)"
  Add-Row -ItemName '  AV State'   -ItemValue $($AV.productState)
  Add-Row -ItemName ' '            

# Windows Update Information

  $WU = Get-WindowsUpdateConfig
  Add-Row -ItemName 'Windows Update'
  Add-Row -ItemName '  Notification Level'  -ItemValue $WU.NotificationLevel
  Add-Row -ItemName '  Update Days'         -ItemValue $WU.UpdateDays
  Add-Row -ItemName '  Update Hour'         -ItemValue $WU.UpdateHour
  Add-Row -ItemName '  Recommended Updates' `
          -ItemValue $WU.'Recommended updates'
  Add-Row -ItemName ' '            

#PowerShell Information

  Add-Row -ItemName "PowerShell Information"
  Add-Row -ItemName "  PS Version"             -ItemValue `
                                         "$($PSVersionTable.PSVersion)"
  Add-Row -ItemName "  Runtime Lang. Version"  -ItemValue `
     "$($PSVersionTable.clrversion.Major).$($PSVersionTable.clrversion.Minor)"
  Add-Row -ItemName "  WS-Man Stack  Version"  -ItemValue `
                                        "$($PSVersionTable.WsManStackVersion)"
  Add-Row -ItemName "  PS Remoting   Version"  -ItemValue `
                    ("$($PSVersionTable.PSRemotingProtocolVersion.Major)." + 
                     "$($PSVersionTable.PSRemotingProtocolVersion.Minor)")
  Add-Row -ItemName ' '                        


#.Net Information

  Add-Row -ItemName ".Net Versions"

  Get-ChildItem  -Recurse `
                 -Path 'HKLM:\SOFTWARE\Microsoft\NET Framework Setup\NDP' |
  Get-ItemProperty -Name Version -EA 0 |
  Where-Object { $_.PSChildName -Match '^(?!S)\p{L}'} | 
    ForEach-Object {
      Add-Row -ItemName "  $($_.PSChildName)"   -ItemValue "$($_.Version)"
    }

  $OSTabEndCnt = $CITable.Rows.Count - 1

#---------------------  End Windows Tab Information --------------------

# --------------------- Video Tab Information --------------------------

  $Video = Get-WmiObject -Class Win32_VideoController -ComputerName $compname 
 
  $VideoTabStartCnt = $CITable.Rows.Count
  Add-Row -ItemName 'Video Name' -ItemValue $Video.Name
  Add-Row -ItemName '  RAM (Mb)' -ItemValue ($Video.AdapterRAM/1mb)
  Add-Row -ItemName '  Mode Description' `
          -ItemValue  $Video.VideoModeDescription
  Add-Row -ItemName '  Refresh Rate' `
          -ItemValue $Video.CurrentRefreshRate
  Add-Row -ItemName '  Installed Drivers' `
          -ItemValue $Video.InstalledDisplayDrivers
  Add-Row -ItemName '  Driver Date' `
          -ItemValue ($Video.ConvertToDateTime($Video.DriverDate))
  Add-Row -ItemName '  Driver Version' -ItemValue $Video.DriverVersion
  $VideoTabEndCnt = $CITable.Rows.Count - 1

# ------------------ Registry/Services Tab Information -----------------------

  $ServicesTabStartCnt = $CITable.Rows.Count
  $Prop = Get-ItemProperty `
        -Path "HKLM:\SYSTEM\CurrentControlSet\Control\Session Manager\Power" `
        -Name "HiberbootEnabled" 
  Add-Row -ItemName "Registry: HiberbootEnabled" `
          -ItemValue ([Bool]$($Prop.HiberbootEnabled.Equals(1))) 

  $Prop = Get-ItemProperty `
          -Path "HKLM:SYSTEM\CurrentControlSet\Control\Power" `
          -Name "HibernateEnabled" 
  Add-Row -ItemName "Registry: HibernateEnabled" `
          -ItemValue ([Bool]$($Prop.HibernateEnabled.Equals(1)))  

  Get-Service -Name HomeGroup*,USBDLM*,Macrium*,Remote*,MsKey*,
                    VSS,Wsearch,DiagTrack | 
     ForEach-Object  {
        Add-Row -ItemName "Service:  $($_.DisplayName)" `
                -ItemValue $($_.Status)
     }

  Add-Row -ItemName ''
  Add-Row -ItemName '--- Security ---'
  $UAC = Get-ItemProperty `
     -Path "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System" `
     -Name "EnableLUA"
  Add-Row -ItemName 'Registry: UAC Enabled' `
          -ItemValue ($UAC.EnableLUA.Equals(1)) 

  Get-Service -Name MBAM*,EMET*,WinDefend*,MpsSvc,wuauserv,BDESVC,fhsvc | 
     ForEach-Object  {
        Add-Row -ItemName "Service:  $($_.DisplayName)" `
                -ItemValue $($_.Status)
     }

  $ServicesTabEndCnt = $CITable.Rows.Count - 1

#---------------------- Monitor Info for Video Tab ------------------------
 
$Mons = get-wmiobject -Query `
          'select * from Win32_PnPEntity where service="monitor"' | 
          Select-Object -Property Name, Manufacturer, HardwareID 

$Mons | Add-Member -Name 'SerialNo' -MemberType 'NoteProperty' -Value $null

ForEach ($xx in $Mons) {

$ErrorActionPreference = 'SilentlyContinue'

   $Separator = "{","\","}"
   $xx.HardwareID = $xx.HardwareId.split($Separator)[1]

   $keytype=[Microsoft.Win32.RegistryHive]::LocalMachine
   $reg=[Microsoft.Win32.RegistryKey]::OpenRemoteBaseKey($keytype,"")
   $regKey= $reg.OpenSubKey("SYSTEM\\CurrentControlSet\\Enum\DISPLAY" ) 

   $regKey = $reg.OpenSubKey(
            "SYSTEM\\CurrentControlSet\\Enum\\DISPLAY\\$($xx.HardwareId)")  
   $DID = $regkey.GetSubKeyNames() 
                   
   ForEach($DID_KEY_NAME in $DID) {
    
         $regKey= $reg.OpenSubKey(
             "SYSTEM\\CurrentControlSet\\Enum\\DISPLAY\\$($xx.HardwareId)" + 
             "\\$($DID_KEY_NAME)\\Device Parameters") 
         $EDID = $regKey.GetValue("EDID") 

         ForEach($int in $EDID){ 

           $EDID_String = $EDID_String+([char]$int) 

         } 
             
         #Serial Number 
         $checkstring = 
            [char]0x00 + [char]0x00 + [char]0x00 + [char]0xFF + [char]0x00            
         $matchfound =  $EDID_String -match "$checkstring(\S+)" 
         if($matchfound){
           $xx.SerialNo = [String]$matches[1]}
         else {
         $xx.SerialNo = '-'
         #$monrow.Serial = '-'
         } 
                               
         $EDID_String = '' 

   }   # End - foreach($DID_KEY_NAME in $DID)
                    

}   #  End ---- ForEach $xx ----

 $ErrorActionPreference = 'Continue'
   
GenerateForm