﻿
Function Get-ArchitectureString {

# Determine bitness of OS and load appropriate files.

  $Arch=(Get-CimInstance win32_operatingsystem).OSArchitecture
  if ($Arch -eq '32-Bit') {
     Return [string]' (x86)'
  }
  Else { 
     Return [string]'amd64'
  }
} #End Function Get-ArchitectureString

Function Test-WindowsADK {

<# Test to see if the ADK is installed in the Default Location!
   64-Bit = C:\Program Files (x86)\...
   32-Bit = C:\Program Files\...
#>
  $SubFolder = Get-ArchitectureString
  
  If ($SubFolder -eq 'amd64') {
    $SubFolder = ' (x86)'
  }
  Else {
    $SubFolder = ''
  }

  Return $(Test-Path -Path (
            "C:\Program Files$($SubFolder)\Windows Kits\10\" +
            "Assessment and Deployment Kit" +
            "\Windows Preinstallation Environment"))
            
} #End Function Test-WindowsADK

#----- Setup Working Environment -----

$StartTime = Get-Date
$Error.Clear()  #Set Error Count to zero!
Clear-Host

If (-not(Test-WindowsADK)) {
  Write-Host "Windows ADK not Detected!`n`nPlease Install..."
  Exit
}

$WinADK="C:\Program Files (x86)\Windows Kits\10\" +
        "Assessment and Deployment Kit" +
        "\Windows Preinstallation Environment\" +
        "$(Get-ArchitectureString)"
$WinPETemp='G:\TempPE'

New-Item -ItemType Directory -Path "$($WinPETemp)\Media" -force
$CIArgs = @{path        = "$($WinAdk)\en-us\winpe.wim" 
            Destination = "$($WinPETemp)\Media\boot.wim"}
Copy-Item @CIArgs
New-Item -ItemType Directory -Path "$($WinPETemp)\Mount" –Force

#----- Mount the WinPE WIM file for Editing -----

$MTArgs = @{ImagePath = "$($WinPETemp)\Media\boot.wim" 
            Index     = 1 
            path      = "$($WinPETemp)\Mount"}
Mount-WindowsImage @MTArgs

#--- Packages List - PowerShell, Storage, and DISM cmdlets --#
$PkgList = @(
    "WinPE-WMI.cab", 
    "en-us\WinPE-WMI_en-us.cab", 
    "WinPE-NetFx.cab", 
    "en-us\WinPE-NetFx_en-us.cab", 
    "WinPE-Scripting.cab", 
    "en-us\WinPE-Scripting_en-us.cab", 
    "WinPE-PowerShell.cab", 
    "en-us\WinPE-PowerShell_en-us.cab", 
    "WinPE-DismCmdlets.cab", 
    "en-us\WinPE-DismCmdlets_en-us.cab", 
    "WinPE-EnhancedStorage.cab", 
    "en-us\WinPE-EnhancedStorage_en-us.cab", 
    "WinPE-StorageWMI.cab", 
    "en-us\WinPE-StorageWMI_en-us.cab") 

 ForEach ($Pkg in $PkgList) {
 $AWPArgs = @{PackagePath = "$($WinAdk)\Winpe_OCS\$($Pkg)"
              Path        = "$($WinPETemp)\Mount"
              IgnoreCheck = $true }

 Add-WindowsPackage @AWPArgs 

 } #End ForEach ($Pkg...

<#
  Add your modifications now...
  Such as Directory for User Scripts, 
  Registry Modifications, specifically Powershell 
  Execution Policy
#>

#--- Add User Directories ---
$UserDirectories = @("Utilities","Scripts")

ForEach ($Dir in $UserDirectories) {
  $NIArgs = @{ItemType = 'Directory' 
              Path     = "$($WinPETemp)\Mount\Users\$($Dir)"}
  New-Item @NIArgs
}

#--- Add PowerShell Profile ---
$CIArgs = @{Path        = 
 "G:\WinPE Include Files\Microsoft.PowerShell_profile.ps1"
            Destination = 
 "$($WinPETemp)\Mount\Windows\System32\WindowsPowerShell\V1.0"}

 Copy-Item @CIArgs

#--- Add User Scripts to Directory ---

$Scripts = @("GetDotNetVersionsInstalled.ps1",
             "PSVersionID.ps1")

ForEach ($FN in $Scripts) {
  $CIArgs = @{Path        = "G:\BEKDocs\Scripts\$FN" 
              Destination = "$($WinPETemp)\Mount\Users\Scripts"}
  Copy-Item @CIArgs
}

#--- Add Portable Pgms to the Utilities Directory     ---
#--- Note: Must be 64 bit Programs no support for WOW ---

$Utilities = @("Speccy64\Speccy64.exe",
               "HWiNFO64\HWiNFO64.exe")

ForEach ($FN in $Utilities) {
  $CIArgs = @{Path        = "G:\BEKDocs\NonInstPrograms\$FN" 
              Destination = "$($WinPETemp)\Mount\Users\Utilities"}
  Copy-Item @CIArgs
}

#--- Mount WinPE Registry to the Local Registry for mods ---
$RegLoc = "$($WinPETemp)\Mount\Windows\System32\config\software"
reg load "HKLM\WimPE" "$RegLoc"

#--- Modify PowerShell Execution Policy in WIM Registry ---
$RegPath = "HKLM:\WimPE\Microsoft\PowerShell\1\ShellIds" +
           "\Microsoft.PowerShell\"
$NIArgs = @{Path  = $RegPath 
            Name  = 'ExecutionPolicy' 
            Value = "RemoteSigned"
            PropertyType = 'String'
            Force = $True}

New-ItemProperty @NIArgs

reg unload "HKLM\WimPE"  #--- UnMount WinPE registry ---

#----- DisMount the Modified WinPE WIM File -----

Dismount-WindowsImage -path "$($WinPETemp)\Mount" -Save

#----- Make a Backup of the Modified WIM file -----

$Destination='G:\Pewim'
New-Item -Path $Destination -ItemType Directory –Force

$CIArgs = @{Path        = "$($WinPETemp)\Media\boot.wim" 
            Destination = "$($Destination)\"}
Copy-Item @CIArgs

"`n`nProgram Elapsed Time: " + 
  "$((($(Get-Date) - $StartTime).ToString()).Substring(0,8))" +
  " with $($error.count) error(s)."