﻿# Win7 Powershell script to resize Minecraft to 1280x720 (HD for fraps youtube capture)
# use by typing the following at a command prompt:
# > PowerShell -ExecutionPolicy Bypass -File minecraft-sethd.ps1
# refs:
# http://stackoverflow.com/questions/2556872/how-to-set-foreground-window-from-powershell-event-subscriber-action
# http://richardspowershellblog.wordpress.com/2011/07/23/moving-windows/
# http://www.suite101.com/content/client-area-size-with-movewindow-a17846

Add-Type @"
using System;
using System.Runtime.InteropServices;
public class Win32 {
[DllImport("user32.dll")]
[return: MarshalAs(UnmanagedType.Bool)]
public static extern bool GetWindowRect(IntPtr hWnd, out RECT lpRect);
[DllImport("user32.dll")]
[return: MarshalAs(UnmanagedType.Bool)]
public static extern bool GetClientRect(IntPtr hWnd, out RECT lpRect);
[DllImport("user32.dll")]
[return: MarshalAs(UnmanagedType.Bool)]
public static extern bool MoveWindow(IntPtr hWnd, int X, int Y, int nWidth, int nHeight, bool bRepaint);
}
public struct RECT
{
public int Left;   // x position of upper-left corner
public int Top;    // y position of upper-left corner
public int Right;  // x position of lower-right corner
public int Bottom; // y position of lower-right corner
}
"@


Function Set-WindowSizePosition {

  Param (
    [Parameter(Mandatory=$True)]
      [String] $AppName,
    [Parameter(Mandatory=$True)]
      [Int] $AppWindWidth,
    [Parameter(Mandatory=$True)]
      [Int] $AppWindHeight,
    [Parameter(Mandatory=$True)]
      [Int] $AppWindLeft,
    [Parameter(Mandatory=$True)]
      [Int] $AppWindTop
  )

  $AppWindow = New-Object RECT
  $ScrnWindow = New-Object RECT
  
  $h = (Get-Process | where {$_.ProcessName -eq "$AppName"})
  
  If ($h -ne $null) {
    $h = $h.MainWindowHandle
    [Win32]::GetWindowRect($h,[ref]$AppWindow)
    [Win32]::GetClientRect($h,[ref]$ScrnWindow)
    Write-host "dx: $dx   dy: $dy"
    #Position Top left of screen 2! 1920 x 1080 screen
    #To address a 2nd screen start at 1920!
    [Win32]::MoveWindow($h, $AppWindLeft, $AppWindTop, 
             $AppWindWidth, $AppWindHeight, $true )
  } #End If ($h -ne...

} #End Function Set-WindowSizePosition

$SWSPArgs = @{AppName       = "powershell_ise"
              AppWindWidth  = 1920
              AppWindHeight = 1040
              AppWindLeft   = 0 
              AppWindTop    = 0}
Set-WindowSizePosition @SWSPArgs

$SWSPArgs = @{AppName       = "notepad++"
              AppWindWidth  = 963 
              AppWindHeight = 1040 
              AppWindLeft   = 1915
              AppWindTop    = 0}
Set-WindowSizePosition @SWSPArgs

$SWSPArgs = @{AppName       = "OUTLOOK"
              AppWindWidth  = 965
              AppWindHeight = 1040
              AppWindLeft   = 1915+963 #Calculate based on Pos of Notepad++
              AppWindTop    = 0}
Set-WindowSizePosition @SWSPArgs