﻿<#
  .Synopsis
    Configure a group of program windows into a desired
    configuration on the screen or across multiple screens
    and opening the program if necessary.

  .Description
    This program allows the user to configure a desired work
    configuration of program windows, opening the applications
    if necessary, including the height & width of the windows
    and the position on the screen or across multiple screens.
    To setup different configurations create a copy of this
    program and make the necessary adjustments.

  .Outputs
    Applications opened and windows positioned and sized 
    the on screen(s).

  .Notes
     Programmer   : RetiredGeek (WSL) aka: ComputerMentor
     Created      : 21 Jul 2016
     Last Updated : 
     Current Vers : 7.0

  .Example
   C:\Windows\System32\WindowsPowerShell\v1.0\powershell.exe 
      -File "G:\BEKDocs\Scripts\Set-WorkEnv.ps1"

   Place the above in a Shortcut as the Target to run this 
   program from the desktop.
#>



<#+-----------------------------------------------+
  | Applications list Hash Table:                 |
  | AppName = Application path & program file     |
  | AppName should be the same value as shows up  |
  | in the Get-Process listing. Note the use of   |
  | single quotes on the notepad++ entry as the + |
  | causes syntax errors in usage.                |
  | Application path is the full execution path   |
  | and filename.extension.                       |
  | Note the use of the MSOfficeBase variable to  |
  | keep the command lines shorter.               |
  |                                               |
  | Note: The hash table is here and not in the   |
  |       function so that you can use different  |
  |       sets of programs w/o having to change   |
  |       the code in the function. Just remember |
  |       the table MUST be called AppList!       |
  +-----------------------------------------------+
#>
$MSOfficeBase = 
   'C:\Program Files (x86)\Microsoft Office\Office14\'
$AppList = @{
 OUTLOOK     = ($MSOfficeBase + 'Outlook.exe')
 EXCEL       = ($MSOfficeBase + 'Excel.exe')
 WINWORD     = ($MSOfficeBase + 'WINWORD.exe')
 MSACCESS    = ($MSOfficeBase + 'MSAccess.exe')
 ONENOTE     = ($MSOfficeBase + 'ONENOTE.exe')
 MSPUB       = ($MSOfficeBase + 'MSPUB.exe')
 POWERPNT    = ($MSOfficeBase + 'POWERPNT.exe')
 i_view64    = 'C:\Program Files\IrfanView\i_view64.exe'
 'notepad++' = 'C:\Program Files (x86)\Notepad++\notepad++.exe'
 powershell_ise = 
    ('G:\BEKDocs\BTB\PowerShell\2 - 64Bit PS ISE as Admin.lnk')
 }

 $DebugFile    = 
   "$([Environment]::GetFolderPath('MyDocuments'))\WorkEnv.log"
 $EffScrnWidth  = 1536
 $EffScrnHeight = 826  #Height-Taskbar height! 
                       #Not necessary if Autohide the taskbar.

#Adjust Drive\Path below to match location on your machine!

. 'G:\BEKDocs\Scripts\Function-Set-WindowSizePosition.ps1'

Clear-Host

$SWSPArgs = @{AppName       = "Excel"
              AppWindWidth  = $EffScrnWidth
              AppWindHeight = $EffScrnHeight
              AppWindLeft   = 0 
              AppWindTop    = 0
              DelaySeconds  = 1}
Set-WindowSizePosition @SWSPArgs #-Verbose 4>&1 >> "$DebugFile"


$SWSPArgs = @{AppName       = "notepad++"
              AppWindWidth  = [Int]($EffScrnWidth/2)
              AppWindHeight = $EffScrnHeight
              AppWindLeft   = $EffScrnWidth  #Second Screen
              AppWindTop    = 0
              DelaySeconds  = 1}
Set-WindowSizePosition @SWSPArgs #-Verbose 4>&1 >> "$DebugFile"

$SWSPArgs = @{AppName       = "OUTLOOK"
              AppWindWidth  = [Int]($EffScrnWidth/2)
              AppWindHeight = $EffScrnHeight
              AppWindLeft   = [Int]($EffScrnWidth+($EffScrnWidth/2))
              AppWindTop    = 0
              DelaySeconds  = 2} #Outlook takes longer to open!
Set-WindowSizePosition @SWSPArgs #-Verbose 4>&1 >> "$DebugFile"
