﻿#Turn on PowerShell Remoting for Server to allow WMI access

Enable-PSRemoting -Force

#Make sure the Client can get through the Server's Firewall!

$GNFRArgs = @{Name = "WMI-WINMGMT-In-TCP"}
$FWRule = get-netfirewallrule @GNFRArgs

If ($fwrule.enabled.value__ -eq 2) {
  Enable-NetFirewallRule @GNFRArgs
}

#Make Sure Required Services are Running on the Server!

$Services = @("RpcSs","SessionEnv","TermService","UmRdpService")

ForEach ($Service in $Services) {

   $CurSvc = Get-Service -Name "$Service"

   If ($CurSvc.Status -eq "Stopped") {
     Start-Service -Name $Service -ErrorAction "SilentlyContinue"
   }

} #End ForEach