﻿<#
  .Synopsis
   Enable PSRemoting and insure that the Windows Firewall will
   allow access and all required services are running.

  .Description
   Run the Enable-PSRemoting cmd-let.
   Clears a way through the Windows Firewall for the remoting
   requests.
   Ensures that the necessary services are running.  

  .Outputs
   Commands to windows to enable remoting, firewall rules, and
   service initiation. 

  .Notes
     Programmer   : RetiredGeek (WSL) aka: ComputerMentor
     Created      : Jun 07, 2016
     Last Updated : Jan 20, 2017
     Current Vers : V1.1
     Privleges    : Run as Administrator!

  .Example
   Set-PSRemoting.ps1

#>


# Two blank linea above required for Comment-Based Help

#Turn on PowerShell Remoting for Server to allow WMI access

Enable-PSRemoting -Force

#Make sure the Client can get through the Server's Firewall!

$GNFRArgs = @{Name = "WMI-WINMGMT-In-TCP"}
$FWRule = get-netfirewallrule @GNFRArgs

If ($fwrule.enabled.value__ -eq 2) {
  Enable-NetFirewallRule @GNFRArgs
}

<#Make Sure Required Services are Running on the Server!
  RPCSS       : Remote Procedure Call (RPC)
  SessionEnv  : Remote Desktop Configuration
  TermService : Remote Desktop Services
  UmRDPService: Remote Desktop Services UserMode Port Redirector
#>

$Services = @("RpcSs","SessionEnv","TermService","UmRdpService")

ForEach ($Service in $Services) {

   $CurSvc = Get-Service -Name "$Service"

   If ($CurSvc.Status -eq "Stopped") {
     Start-Service -Name $Service -ErrorAction "SilentlyContinue"
   }

} #End ForEach