﻿<#
.Synopsis
   Return the Windows 10 Version information

.Description
   Displays a dialog box that contains the windows 10
   verion information with links to the Release and
   Build information. The data is also copied to the
   clipboard for posting into help sites like AskWood.com 

.Outputs
    Dialog Box
    Data copied to clipboard

.Notes
     Programmer   : RetiredGeek (WSL) aka: ComputerMentor
     Created      : 11 Mar 2019
     Last Updated : 24 Mar 2019
     Current Vers : 3.0
     Credits      :
       *** Based on Auto Hot Key Script by Rick Corbett ***

.Example
   [d:\path\]Get-WinVerV3.ps1

#>


# Two blank linea above required for Comment-Based Help

Function Show-Dialog {

$Form_Width    = 400
$Form_Height   = 420
$Btn_Height    =  25
$Btn_Width     = 370
$StdSpacing    =  35
$tbox_Width    = 370
$tbox_Height   = 220

[xml]$xaml = @"
<Window 
  xmlns =
    "http://schemas.microsoft.com/winfx/2006/xaml/presentation"
  xmlns:x  = "http://schemas.microsoft.com/winfx/2006/xaml"
    Name = "Window" 
              Title         = "$WindowTitle" 
              WindowStartupLocation = "CenterScreen"
              Width         = "$Form_Width" 
              Height        = "$Form_Height" 
              FontSize      = "18" 
              Background="Blue" Foreground="White"
              ShowInTaskbar = "True">

    <Window.Resources>

      <Style x:Key="BtnStyle" TargetType="Button">
       <Setter Property="Height"        Value="$Btn_Height"/>
       <Setter Property="Canvas.Bottom" Value="2"          />
       <Setter Property="Background"    Value="Blue"       />
       <Setter Property="Foreground"    Value="Yellow"     />
       <Setter Property="Margin"        Value="5"          />
       <Setter Property="FontSize"      Value="20"         />
      </Style>

      <Style x:Key="TBoxStyle" TargetType="TextBox">
       <Setter Property="Height"     Value="$tbox_Height"   />
       <Setter Property="Width"      Value="$tbox_Width"    />
       <Setter Property="Margin"     Value="5"              />
       <Setter Property="Background" Value="Blue"           />
       <Setter Property="Foreground" Value="White"          />
       <Setter Property="FontFamily" Value="Tahoma"        />
       <Setter Property="FontSize"   Value="20"             />
       <Setter Property="IsReadOnly" Value="$True"          />
       <Setter Property="VerticalScrollBarVisibility" 
                                                Value="Hidden"/>
      </Style>

    </Window.Resources>
        
    <Canvas>

        <TextBox   x:Name="tboxVerInfo"  
                   Style="{StaticResource TBoxStyle}"
                   Margin="10,10,0,0" />    
        <Button x:Name="VersionInfoBtn"  
                Content='Click here for Version Info'
                Height="$Btn_Height" Width="$Btn_Width" 
                Background="Green" Foreground="Yellow"
                ToolTip = "Version Info"  
                Margin="10,$(($StdSpacing += ($tbox_Height + 10))),0,0" />
        <Button x:Name="BuildInfoBtn" 
                Content='Click here for Release Info'
                Height="$Btn_Height" Width="$Btn_Width" 
                Background="Green" Foreground="Yellow"
                ToolTip = "Release Info"  
                Margin  = "10,$(($StdSpacing += ($Btn_Height + 10))),0,0"/>
        <Button x:Name="ExitBtn" Content='Exit'
                Height="$Btn_Height" Width="80" 
                Canvas.Bottom="5" Canvas.Right="5"
                Background="Red" Foreground="Yellow"
                ToolTip = "Exit"  
                Margin="5" />

    </Canvas>
</Window>
"@

$NOArgs = @{TypeName = 'System.Xml.XmlNodeReader'
            ArgumentList = $xaml}
$reader=(New-Object @NOArgs)

Try  {$Form=[Windows.Markup.XamlReader]::Load( $reader )}
Catch{Write-Host "Unable to load Windows.Markup.XamlReader." +
                 "`nDouble-check syntax and ensure " +
                 ".net is installed."
     }

$Form.Topmost = $False
$Form.Cursor = [System.Windows.Input.Cursors]::Hand

$tboxVerInfo = $Form.FindName("tboxVerInfo")
$tboxVerInfo.AddText($VersionMsg)

$VersionInfoBtn = $Form.FindName("VersionInfoBtn")
$VersionInfoBtn.Add_Click({
    [system.Diagnostics.Process]::start(
       "https://support.microsoft.com/en-us/help/$VerURL")
    $VersionInfoBtn.Foreground="Purple"})

$BuildInfoBtn = $Form.FindName("BuildInfoBtn")
$BuildInfoBtn.Add_Click({
    [system.Diagnostics.Process]::start(
       "https://support.microsoft.com/en-us/help/$BuildURL")
    $BuildInfoBtn.Foreground="Purple"})

$ExitBtn = $Form.FindName("ExitBtn")
$ExitBtn.Add_Click({$Form.Close()})

#Mandetory last line of every script to load form
$Form.ShowDialog()

} #End Function Show-Dialog()

Function Get-VersionURL {

  $verURL = (& { Switch ($ReleaseID) {
                  '1511' { '4000824' } 
                  '1607' { '4000825' }
                  '1703' { '4018124' }
                  '1709' { '4043454' }
                  '1803' { '4099479' }
                  '1809' { '4464619' }
                 }
                } )

  "$VerURL"

} #End Get-SupportURL

Function Get-BuildURL {

#Update Info @: https://support.microsoft.com/en-us/help/4464619

  $Build = "$BuildNo.$ReleaseNo"

  $BuildURL = (& { Switch ($Build) {
                  '10586.154'  { '4093109' }
                  '10586.1478' { '4088779' }
                  '10586.1417' { '4074591' }
                  '10586.1358' { '4075200' }
                  '10586.1356' { '4056888' }
                  '10586.1295' { '4053578' }
                  '10586.1232' { '4048952' }
                  '10586.1177' { '4052232' }
                  '10586.1176' { '4041689' }
                  '10586.1106' { '4038783' }
                  '10586.1045' { '4054660' }
                  '10586.1007' { '4025344' }
                  '10586.965'  { '4032693' }
                  '10586.962'  { '4022714' }
                  '10586.916'  { '4019473' }
                  '10586.873'  { '4015219' }
                  '10586.842'  { '4016636' }
                  '10586.839'  { '4013198' }
                  '10586.753'  { '3210721' }
                  '10586.713'  { '3205386' }
                  '10586.682'  { '3198586' }
                  '10586.679'  { '3198586' }
                  '10586.633'  { '3192441' }
                  '10586.589'  { '3185614' }
                  '10586.545'  { '3176493' }
                  '10586.494'  { '3172985' }
                  '10586.42'   { '3163018' }
                  '10586.318'  { '3156421' }
                  '10586.218'  { '3147458' }
                  '10586.164'  { '3140768' }
                  '10586.122'  { '3140743' }
                  '10586.104'  { '3135173' }
                  '14393.2608' { '4467691' }
                  '14393.258'  { '4462928' }
                  '14393.2551' { '4462917' }
                  '14393.2515' { '4457127' }
                  '14393.2458' { '4457131' }
                  '14393.2457' { '4343884' }
                  '14393.243'  { '4343887' }
                  '14393.2396' { '4346877' }
                  '14393.2395' { '4338822' }
                  '14393.2368' { '4345418' }
                  '14393.2363' { '4338814' }
                  '14393.2339' { '4284833' }
                  '14393.2312' { '4284880' }
                  '14393.2458' { '4457131' }
                  '14393.2273' { '4103720' }
                  '14393.2248' { '4103723' }
                  '14393.2214' { '4093120' }
                  '14393.2189' { '4093119' }
                  '14393.2156' { '4096309' }
                  '14393.2155' { '4088889' }
                  '14393.2126' { '4088787' }
                  '14393.2125' { '4088787' }
                  '14393.2097' { '4077525' }
                  '14393.2068' { '4074590' }
                  '14393.2034' { '4057142' }
                  '14393.2007' { '4056890' }
                  '14393.1944' { '4053579' }
                  '14393.1914' { '4051033' }
                  '14393.1884' { '4048953' }
                  '14393.1797' { '4052231' }
                  '14393.1794' { '4041688' }
                  '14393.177'  { '4041691' }
                  '14393.1737' { '4038801' }
                  '14393.1715' { '4038782' }
                  '14393.167'  { '4039396' }
                  '14393.1613' { '4034661' }
                  '14393.1593' { '4034658' }
                  '14393.1537' { '4038220' }
                  '14393.1532' { '4025334' }
                  '14393.148'  { '4025339' }
                  '14393.1378' { '4022723' }
                  '14393.1358' { '4022715' }
                  '14393.123'  { '4023680' }
                  '14393.1198' { '4019472' }
                  '14393.1083' { '4015217' }
                  '14393.1066' { '4015217' }
                  '14393.97'   { '4016635' }
                  '14393.969'  { '4015438' }
                  '14393.953'  { '4013429' }
                  '14393.729'  { '4010672' }
                  '14393.726'  { '3216755' }
                  '14393.693'  { '3213986' }
                  '14393.576'  { '3206632' }
                  '14393.479'  { '3201845' }
                  '14393.448'  { '3200970' }
                  '14393.447'  { '3200970' }
                  '14393.351'  { '3197954' }
                  '14393.321'  { '3194798' }
                  '14393.222'  { '3194496' }
                  '14393.189'  { '3193494' }
                  '14393.187'  { '3193494' }
                  '14393.105'  { '3176938' }
                  '14393.82'   { '3176934' }
                  '14393.51'   { '3176495' }
                  '14393.1'    { '3176929' }
				  '15063.1716' { '4489888' }
				  '15063.1689' { '4489871' }
				  '15063.1659' { '4487011' }
				  '15063.1631' { '4487020' }
				  '15063.1596' { '4480959' }
				  '15063.1563' { '4480973' }
				  '15063.1508' { '4483230' }
				  '15063.1506' { '4471327' }
				  '15063.1478' { '4467699' }
                  '15063.1446' { '4467696' }
                  '15063.1418' { '4462939' }
                  '15063.1387' { '4462937' }
                  '15063.1358' { '4457141' }
                  '15063.1324' { '4457138' }
                  '15063.1292' { '4343889' }
                  '15063.1266' { '4343885' }
                  '15063.1235' { '4338827' }
                  '15063.1209' { '4345419' }
                  '15063.1206' { '4338826' }
                  '15063.1182' { '4284830' }
                  '15063.1155' { '4284874' }
                  '15063.1112' { '4103722' }
                  '15063.1088' { '4103731' }
                  '15063.1058' { '4093117' }
                  '15063.1029' { '4093107' }
                  '15063.994'  { '4088891' }
                  '15063.968'  { '4088782' }
                  '15063.966'  { '4088782' }
                  '15063.936'  { '4092077' }
                  '15063.909'  { '4074592' }
                  '15063.877'  { '4057144' }
                  '15063.85'   { '4056891' }
                  '15063.786'  { '4053580' }
                  '15063.729'  { '4055254' }
                  '15063.728'  { '4048954' }
                  '15063.726'  { '4048954' }
                  '15063.675'  { '4049370' }
                  '15063.674'  { '4041676' }
                  '15063.632'  { '4040724' }
                  '15063.608'  { '4038788' }
                  '15063.54'   { '4034674' }
                  '15063.502'  { '4032188' }
                  '15063.483'  { '4025342' }
                  '15063.447'  { '4022716' }
                  '15063.414'  { '4022725' }
                  '15063.413'  { '4022725' }
                  '15063.332'  { '4020102' }
                  '15063.297'  { '4016871' }
                  '15063.296'  { '4016871' }
                  '15063.25'   { '4016240' }
                  '15063.138'  { '4015583' }
                  '15063.13'   { '4016251' }
				  '16229.1059' { '4489890' }
				  '16299.1029' { '4489886' }
				  '16299.1004' { '4487021' }
				  '16299.967'  { '4486996' }
				  '16299.936'  { '4480967' }
				  '16299.904'  { '4480978' }
				  '16299.847'  { '4483232' }
				  '16299.846'  { '4471329' }
				  '16299.820'  { '4467681' }
                  '16299.785'  { '4467686' }
                  '16299.755'  { '4462932' }
                  '16299.726'  { '4462918' }
                  '16299.699'  { '4457136' }
                  '16299.666'  { '4464217' }
                  '16299.665'  { '4457142' }
                  '16299.637'  { '4343893' }
                  '16299.611'  { '4343897' }
                  '16299.579'  { '4338817' }
                  '16299.551'  { '4345420' }
                  '16299.547'  { '4338825' }
                  '16299.522'  { '4284822' }
                  '16299.492'  { '4284819' }
                  '16299.461'  { '4103714' }
                  '16299.431'  { '4103727' }
                  '16299.402'  { '4093105' }
                  '16299.371'  { '4093112' }
                  '16299.334'  { '4089848' }
                  '16299.309'  { '4088776' }
                  '16299.251'  { '4090913' }
                  '16299.248'  { '4074588' }
                  '16299.214'  { '4058258' }
                  '16299.201'  { '4073291' }
                  '16299.192'  { '4056892' }
                  '16299.125'  { '4054517' }
                  '16299.98'   { '4051963' }
                  '16299.64'   { '4048955' }
                  '16299.19'   { '4043961' }
				  '17134.677'  { '4489894' }
				  '17134.648'  { '4489868' }
				  '17134.619'  { '4487029' }
				  '17134.590'  { '4487017' }
				  '17134.556'  { '4480976' }
				  '17134.523'  { '4480966' }
				  '17134.472'  { '4483234' }
				  '17134.471'  { '4471324' }
				  '17134.441'  { '4467682' }
                  '17134.407'  { '4467702' }
                  '17134.376'  { '4462933' }
                  '17134.345'  { '4462919' }
                  '17134.32'   { '4458469' }
                  '17134.286'  { '4464218' }
                  '17134.285'  { '4457128' }
                  '17134.254'  { '4346783' }
                  '17134.228'  { '4343909' }
                  '17134.191'  { '4340917' }
                  '17134.167'  { '4345421' }
                  '17134.165'  { '4338819' }
                  '17134.137'  { '4284848' }
                  '17134.112'  { '4284835' }
                  '17134.83'   { '4338548' }
                  '17134.81'   { '4100403' }
                  '17134.48'   { '4103721' }
                  '17763.134'  { '4467708' }
                  '17763.107'  { '4464455' }
                  '17763.55'   { '4464330' }
                  '17763.107'  { '4464455' }
                  '17763.134'  { '4467708' }
                  '17763.168'  { '4469342' }
                  '17763.194'  { '4471332' }
                  '17763.195'  { '4483235' }
                  '17763.253'  { '4480116' }
                  '17763.292'  { '4476976' }
                  '17763.316'  { '4487044' }
                  '17763.348'  { '4482887' }
                  '17763.379'  { '4489899' }

                  Default {"$Build is not supported`n" +
                           "by this program!"}
                  }
                } )

  "$BuildURL"

} #End Get-BuildURL

#--------------   Main Program ----------------

Clear-Host

#Load required libraries
$TermMsg = {
  [Windows.Forms.MessageBox]::Show($Message,
                                   "Program Terminated:", 
  [Windows.Forms.MessageBoxButtons]::OK , 
  [Windows.Forms.MessageBoxIcon]::Information) | Out-Null}

Add-Type -AssemblyName "System.Windows.Forms"

If ($host.Name -eq 'ConsoleHost' -or
    $host.Name -eq 'Visual Studio Code Host') {

  try{  <#+------------------------------------------------+
          | Check that the proper assemblies are loaded    |
          | Required for PS Console and Visual Code, while |
          | only Systems.Windows.Forms needed for PSISE!   |
          +------------------------------------------------+
        #>
    $ATArgs = @{AssemblyName = "PresentationCore",
                               "PresentationFramework",
                               "WindowsBase"
                ErrorAction = 'Stop'}
    Add-Type @ATArgs
  } 
  catch {
    $Message = 
        "Failed to load Windows Presentation Framework" +
        " and/or other assemblies required for this program!"
     & $TermMsg
    Exit 
  }
  
} #End If ($host...

$WindowTitle = "RG's Windows 10 Version Info - V3.0"

$GIPArgs = @{Path = "Registry::HKLM\SOFTWARE\Microsoft\" + 
                    "Windows NT\CurrentVersion"
            }

$WinVer = Get-Item @GIPArgs

$ProdName  = $WinVer.getvalue('ProductName')
$ReleaseID = $Winver.getvalue('ReleaseId')
$ReleaseNo = $winVer.getvalue('UBR')
$BuildNo   = $WinVer.getvalue('CurrentBuildNumber')

$CurOS   = Get-CimInstance -ClassName 'Win32_OperatingSystem'
$Bitness = $CurOS.OSArchitecture

$Message = "Edition:  $ProdName $Bitness`n`n" +
           "Version: $ReleaseId`n`n" +
           "Build:     $BuildNo.$ReleaseNo" 
              
$VersionMsg = $Message + 
    "`n`n     ( The info above has been`n" +
    "       copied to Clipboard )" | Out-String

#Copy Data to the Clipboard
$Message | clip.exe

$verURL      = Get-VersionURL
$BuildURL    = Get-BuildURL

$Ret = Show-Dialog