﻿#---------------  Main Program ------------------------------

Clear-Host
Hide-PowerShell  #Hide the ISE Window
Remove-Variable -Scope Local "*" #Make sure previous run is cleared!

# ----------------  add a helper  --------------------

$SWAArgs = @{name = 'Win32ShowWindowAsync' 
             namespace = 'Win32Functions'}

$showWindowAsync = Add-Type –memberDefinition @"
[DllImport("user32.dll")]
public static extern bool ShowWindowAsync(
            IntPtr hWnd, int nCmdShow);
"@ @SWAargs -PassThru

function Show-PowerShell() { 
     [void]$showWindowAsync::ShowWindowAsync((
           Get-Process –id $pid).MainWindowHandle, 10) 
}

function Hide-PowerShell() { 
    [void]$showWindowAsync::ShowWindowAsync((
          Get-Process –id $pid).MainWindowHandle, 2) 
}

#---------------  end helper -----------------------

$BasePath = "G:\BEKDocs\Scripts" #Change to your path!

$GVArgs = @{Name        = "PSIse"
            Scope       = "Global"
            ErrorAction = "Stop"
           }
Try   { $Null = Get-Variable @GVArgs }
Catch {
       Add-Type -AssemblyName "System.Windows.Forms"
       $TermMsg = {
        [Windows.Forms.MessageBox]::Show($Message,
                                   "Program Terminated:", 
        [Windows.Forms.MessageBoxButtons]::OK , 
        [Windows.Forms.MessageBoxIcon]::Information) | Out-Null}
       $Message = "Only runs in PSISE!"
       $Null = & $TermMsg
       Show-PowerShell
       Exit
      }

$FullPath = ($psise.currentfile.FullPath)
$File     = (($FullPath.Split("\"))[-1])

#--- Copy to Development History Folder ---

$FolderBrowser = New-Object Windows.Forms.FolderBrowserDialog
$FolderBrowser.RootFolder          = 
  [System.Environment+SpecialFolder]'MyComputer'
$FolderBrowser.Description         = 
  "Select Program Version Folder:"
$FolderBrowser.ShowNewFolderButton = $True
$FolderBrowser.SelectedPath        = "$BasePath"

$Result  = $FolderBrowser.ShowDialog()

If ($Result -eq "Cancel") {
  Show-PowerShell
  Exit
}

$NewPath = $FolderBrowser.SelectedPath
If ("$NewPath" -eq "$BasePath") {
  Show-PowerShell
  Exit
}

$DevDir   = (($NewPath.Split("\"))[-1])
$NewFN    = (($File.Split(".")[0]).Replace("Dev-",""))
$NewName  = "$DevDir\" + $NewFN + ".ps1"
$Dest     = $FullPath.Replace("$File","$NewName")

$CIArgs   = @{Path        = "$FullPath"
              Destination = "$Dest" 
              Force       = $True }
Copy-Item @CIArgs

#--- Copy to Production Folder ---
$Title = "Copy to Production:"
$Msg   = "Do you want to copy $NewName to`n" +
         "the Production Directory?"
$Answer = [System.Windows.Forms.MessageBox]::
          Show($MSG , $TITLE, 4, 32) 
If ($Answer -eq "Yes") {
  $ProdName = $NewFN.Substring(0,($NewFN.indexof("-v-",
        [System.StringComparison]::CurrentCultureIgnoreCase)))
  $NewName  = "Production\" + $ProdName + ".ps1"
  $Dest     = $FullPath.Replace("$File","$NewName")
  
  $CIArgs   = @{Path        = "$FullPath"
                Destination = "$Dest" 
                Force       = $True }
}
Copy-Item @CIArgs

Show-PowerShell