﻿<#
.Synopsis
 Add items to the Add-ons menu.

.Description
 Add items to the Add-ons menu of the PowerShell ISE window.
 Items only last the current session so if you want then to
 always be avaliable add a call to this program in your
 PowerShell profile. 

.Outputs
 Menu items on the Add-ons menu. 

.Notes
   Programmer   : RetiredGeek (@askWoody.com) & 
                              (@stackoverflow.com) 
             aka: ComputerMentor
   Created      : 21 Jun 2020
   Last Updated : 
   Current Vers : 1.0

.Example
 [d:\path\]Set-PSISEoptionsMenu.ps1

 Will add the items in the code to the Add-Ons menu of the
 PowerShell ISE, must be run from the ISE!

.Example
 $Null = & [d:\path\]Set-PSISEoptionsMenu.ps1

 Place the above line in your PSProfile to have the program run
 each time you start the PowerShell ISE.
#>


# Two blank linea above required for Comment-Based Help

$GetOptions = 
   $psISE.CurrentPowerShellTab.AddOnsMenu.Submenus.Add(
   "Utilities",$null,$null)
$GetOptions.SubMenus.Add("Version Control", { 
   G:\BEKDocs\Scripts\Production\PSVersionControl.ps1 } , 
   "Ctrl+Alt+V")
<#
$GetOptions.SubMenus.Add("GetColors", {
   C:\fso\Get-PsIseColorValues.ps1 } , $null)

$psISE.CurrentPowerShellTab.AddOnsMenu.Submenus.Add(
   "MyCustomISE", { C:\fso\Set-PsISEcolorsAndFonts.ps1 },$null)
#>

$psISE.CurrentPowerShellTab.AddOnsMenu.Submenus.Add("ClearMenu", 
   { $psISE.CurrentPowerShellTab.AddOnsMenu.Submenus.Clear() },
     $null)
