﻿<#
.Synopsis
 Takes a list of services and returns their dependencies and
 their status [Running | Stopped]

.Description
 Takes a list of services and returns their dependencies and
 their status [Running | Stopped]. Also provides the Display
 name.    

.Parameter SvcName

.Outputs
 Example:

 Service           Requires  Status DisplayName                     
-------           --------  ------ -----------                     
fdphost           RpcSs    Running Remote Procedure Call (RPC)     
fdphost           http     Running HTTP Service                    
fdResPub          http     Running HTTP Service                    
fdResPub          fdphost  Running Function Discovery Provi...
fdResPub          RpcSs    Running Remote Procedure Call (RPC)     
LanManWorkstation NSI      Running Network Store Interface ... 
LanManWorkstation MRxSmb20 Running SMB 2.0 MiniRedirector          
LanManWorkstation Bowser   Running Browser                         
      

.Notes
   Programmer   : RetiredGeek (@askWoody.com) & 
                              (StackOverflow.com) 
             aka: ComputerMentor
   Created      : 10 Jun 2020
   Last Updated : 
   Current Vers : 1.0

.Example
 [d:\path\]Test-ServiceDependencies.ps1 -SvcName "fdphost", 
                            "fdResPub","LanManWorkstation"

 Provides the display as shown above in Outputs.

.Example
 [d:\path\]Test-ServiceDependencies.ps1 "fdphost", 
                            "fdResPub","LanManWorkstation"

 Provides the display as shown above in Outputs.

#>


# Two blank linea above required for Comment-Based Help

Param (

   [Parameter(Mandatory=$True)]
     [String[]] $SvcName
)

Clear-Host
$ErrorList = ""
ForEach ($Svc in $SvcName) {

  $GSArgs = @{Name        = $Svc
              ErrorAction = "Stop"}

  Try {
       $Dep = (get-service @GSArgs).ServicesDependedOn
       ForEach ($Required in $Dep) {
        Get-Service -Name "$($Required.Name)" |
        Select-Object @{e={$Svc}   ;Label="Service" },
                      @{e={$_.Name};Label="Requires"}, 
                      Status, DisplayName
       }
  }
  Catch { $ErrorList += "$SVC`n"}

} #End ForEach ($Svc...

If ($ErrorList -ne "") {
  "`n`nThe following services names are invalid:"
  $ErrorList
}