﻿ <#
  .Synopsis
   Retrieve MS-DEFCON setting from AskWoody.com
   and display in dialog box.

  .Description
   Retrieve MS-DEFCON setting from AskWoody.com
   and display in dialog box.

  .Outputs
   Dialog box with the current MS-DEFCON setting

  .Notes
     Programmer   : RetiredGeek (WSL) aka: ComputerMentor
     Created      : 11 Mar 2019
     Last Updated : 29 Dec 2020
     Current Vers : 4.0

   12/29/20 Fixed problem with Invoke-WebRequest not returning
            images!

  .Example
   [d:\path\]Get-MSDefCon.ps1

#>


# Two blank linea above required for Comment-Based Help

 Function Show-Msg {

  Param ( [Parameter(Mandatory=$True, 
           HelpMessage="Message box content.")]
            [string]$Msg ,
          [Parameter(Mandatory=$False,
           HelpMessage="Message box title.")]
            [string]$Title = "Information"
        ) 
               
[Windows.Forms.MessageBox]::Show($top,"$Msg", "$Title", 
     [Windows.Forms.MessageBoxButtons]::OK , 
     [Windows.Forms.MessageBoxIcon]::Information) 

}  #End Function Show-Msg

#------------------ Main Program -----------------

$DEFCONText = @{
  0 = "Undetermined! `nCouldn't retrieve MS-DefCon value."
  1 = "Current Microsoft patches are causing havoc.`n"     +
     "Don’t patch."
  2 = "Patch reliability is unclear.`n"                    +
     "Unless you have an immediate,`npressing need to "    +
     "install a specific patch,`n`n Don’t do it!"
  3 = "Patch reliability is unclear, "                     +
     "but widespread attacks make patching prudent.`n`n "  +
     "Go ahead and patch, but watch out for "              +
     "potential problems."
  4 = "There are isolated problems with current patches, " +
     "but they are well-known and documented here.`n`n"    +
     " Check this site to see if you’re affected and if "  +
     "things look OK... `n`n Go ahead and patch."
  5 = "All’s clear. Patch while it’s safe."
 }

 #Initialize to null in case can't be retrieved!
 [Int]$DEFCONNo = 0

Add-Type -AssemblyName System.Windows.Forms

$top = 
 new-Object System.Windows.Forms.Form -property @{Topmost=$true}

Clear-Host

$LocalDTFmt = (Get-Culture).DateTimeFormat.ShortDatePattern
$LocalTMFmt = (Get-Culture).DateTimeFormat.ShortTimePattern

$LocalDateTime = Get-Date
$DispDT = (Get-Date $LocalDateTime -Format $LocalDTFmt) +
             " " +
          (Get-Date $LocalDateTime -Format $LocalTMFmt)

$ProgressPreference = "SilentlyContinue"

$IWRArgs = @{URI             = "https://www.askwoody.com/"
             OutFile         = "askwoody.htm"
             UseBasicParsing = $True 
            }
Invoke-WebRequest @IWRArgs

$HTMLLines = get-content -path "askwoody.htm"

foreach ($Line in $HTMLLines) {

  if ($Line -like "*defcon-img*") { 
    $Parts = $Line -split "/"

    for ($Cntr = 0 ; $Cntr -lt $Parts.count; $Cntr++){

       if ($Parts[$Cntr] -like "MS-DEFCON-*") {
       $DEFCONNo = [Int]$Parts[$Cntr].substring(10,1)
       }

    } #For ($Cntr = 0 ...

  } #If ($Line...

} #ForEach ($Line...

$SMArgs = @{Msg   = "MS-DefCon = $DEFCONNo`n`n" +
                     $DEFCONText[$DEFCONNo]
            Title = "AskWoody MS-DEFCON Setting as of: " +
                    "$DispDT"}
$Null = Show-Msg @SMArgs
   