﻿Function Get-WiFi {

  $WiFiResults = ""

  $WiFi = netsh wlan show profiles

  If ($WiFi -Like "*no wireless interface*") {
   $WifiSet = "Wi-Fi Information`n"   +
                   "-----------------`n"   +
                   "$Wifi`n"               | Out-String
   Return ,$WifiSet
  }
 
  For ($Cntr = 0; $Cntr -lt $WiFi.Count; $Cntr++) {

     If ($Wifi[$cntr] -Like "User profiles") {
       $UPStart = ++$Cntr
       Break
     }
  }
  
  For ($Cntr = $UPStart; $Cntr -lt $WiFi.Count; $Cntr++) {

  #*** Retrieve WiFi Information ***
     If ($WiFi[$Cntr] -ne "") {

       $x = $(($Wifi[$Cntr] -split ":")[-1]).Trim()

       $WifiSet = netsh wlan show profile name="$x" key=clear

       If ( $WifiSet -like "*is not found*") {
         #$WiFiResults = $WifiSet
       } #End If

       Else {
         $Mode = $WifiSet |
                 Select-String -pattern "Connection mode"
         $Mode = ($Mode -split ":")[-1].Trim()
     
         $Switch = $WifiSet |
                 Select-String -pattern "AutoSwitch"
         $Switch = ($Switch -split ":")[-1].Trim()
     
         $MacRnd = $WifiSet |
                 Select-String -pattern "MAC Randomization"
         $MacRnd = ($MacRnd -split ":")[-1].Trim()
     
         $Security = $WifiSet |
                     Select-String -Pattern 'Authentication'
         $Security = ($Security -Split ":")[-1].Trim()
     
         $PW = $WifiSet |
                Select-String -Pattern "Key Content"
         If ($Null -ne $PW) {
           $PW = ($PW -Split ":")[-1].Trim()
         }
         Else { $PW = " " }

         $WiFiResults +=
            
            "-----------------`n"             +
            "SSID              : $x`n"     +
            "Connection Mode   : $mode`n"     +
            "Auto Switch       : $Switch`n"   +
            "MAC Randomization : $MacRnd`n"   +
            "Security          : $Security`n" +
            "Password          : $PW`n"       | Out-String
       } #End Else
     
     } #End If ($WiFi[$Cnt] -ne ""...

   } #End For ($Cntr = $UPStart; -lt $WiFi.Count;...

  $WiFiResults = "Wi-Fi Information`n`n" + $WiFiResults | out-string
  Return ,$WifiResults

} #End Function --------------- Get-WiFi ----------------------

Clear-Host

Get-Wifi
