﻿;
; Brian’s Quick Keys version 1.0
; Copyright © 2023 by Brian Livingston, president of BrianLivingston.com.
; Requires Win10 or Win11 and AutoHotKey 2.0 or higher.
; Install AutoHotKey 2.0+ and place this .ahk file in your Startup folder.
; Edit .akh file with any text editor. Save as UTF-8 with BOM (Byte-Order Marker).
; No warranty or tech support. For info, see https://bri.li/quick-keys
; For AHK technical support, see https://www.AutoHotKey.com/boards
;
#SingleInstance         ; Script replaces another instance that is already running.
#Hotstring B C Z ? *    ; Bs on, case-sens., use reset, intraword, no end character.
Persistent              ; Script remains running in memory (default).
;
; Tip: Shift+Apostrophe enters an open single smart quote (‘).
; Apostrophe enters a closed single smart quote (’).
; To enter a double smart quote, press Shift+Apostrophe or Apostrophe twice.
; For straight quotes, press Ctrl+Shift+Apostrophe (") or Crtl+Apostrophe (').
;
; Hotstring              Keystrokes                  Glyph (and description)
; -----------------------------------------------------------------------------
;
^+'::send "{U+0022}"   ; Ctrl+Shift+Apostrophe       " (double straight quote)
^'::send "{U+0027}"    ; Ctrl+Apostrophe             ' (single straight quote)
::``, ::{U+00a0}       ; Backquote Comma Spacebar    nbsp (nonbreaking space)
::``,!::{U+00a1}       ; Backquote Comma !           ¡ (inverted exclamation)
::``$c::{U+00a2}       ; Backquote $ c               ¢ (cent)
::``4c::{U+00a2}       ; Backquote 4 c               ¢ (cent)
::``$l::{U+00a3}       ; Backquote $ l               £ (pound)
::``4l::{U+00a3}       ; Backquote 4 l               £ (pound)
::``$y::{U+00a5}       ; Backquote $ y               ¥ (yen)
::``4y::{U+00a5}       ; Backquote 4 y               ¥ (yen)
::``@s::{U+00a7}       ; Backquote @ s               § (section)
::``2s::{U+00a7}       ; Backquote 2 s               § (section)
::``@c::{U+00a9}       ; Backquote @ c               © (copyright)
::``2c::{U+00a9}       ; Backquote 2 c               © (copyright)
::``$a::{U+00aa}       ; Backquote $ a               ª (feminine ordinal)
::``4a::{U+00aa}       ; Backquote 4 a               ª (feminine ordinal)
::``${::{U+00ab}       ; Backquote $ {               « (double angle quote)
::``4{::{U+00ab}       ; Backquote 4 {               « (double angle quote)
::``@r::{U+00ae}       ; Backquote @ r               ® (registered trademark)
::``2r::{U+00ae}       ; Backquote 2 r               ® (registered trademark)
::``@o::{U+00b0}       ; Backquote @ o               ° (degree)
::``2o::{U+00b0}       ; Backquote 2 o               ° (degree)
::``@p::{U+00b6}       ; Backquote @ p               ¶ (pilcrow)
::``2p::{U+00b6}       ; Backquote 2 p               ¶ (pilcrow)
::``$o::{U+00ba}       ; Backquote $ o               º (masculine ordinal)
::``4o::{U+00ba}       ; Backquote 4 o               º (masculine ordinal)
::``$}::{U+00bb}       ; Backquote $ }               » (double angle quote)
::``4}::{U+00bb}       ; Backquote 4 }               » (double angle quote)
::``/1::{U+00bc}       ; Backquote Slash 1           ¼ (one-quarter)
::``/2::{U+00bd}       ; Backquote Slash 2           ½ (one-half)
::``/3::{U+00be}       ; Backquote Slash 3           ¾ (three-quarters)
::``,?::{U+00bf}       ; Backquote Comma ?           ¿ (inverted question)
::````A::{U+00c0}      ; Backquote Backquote A       À (grave)
::``,A::{U+00c1}       ; Backquote Comma A           Á (acute)
::``^A::{U+00c2}       ; Backquote ^ A               Â (circumflex)
::``6A::{U+00c2}       ; Backquote 6 A               Â (circumflex)
::``~A::{U+00c3}       ; Backquote Tilde A           Ã (tilde)
::``;A::{U+00c4}       ; Backquote ; A               Ä (diaeresis)
::``@A::{U+00c5}       ; Backquote @ A               Å (Aring)
::``2A::{U+00c5}       ; Backquote 2 A               Å (Aring)
::``\A::{U+00c6}       ; Backquote Backslash A       Æ (ligature)
::``,C::{U+00c7}       ; Backquote Comma C           Ç (cedilla)
::````E::{U+00c8}      ; Backquote Backquote A       È (grave)
::``,E::{U+00c9}       ; Backquote Comma E           É (acute)
::``^E::{U+00ca}       ; Backquote ^ E               Ê (circumflex)
::``6E::{U+00ca}       ; Backquote 6 E               Ê (circumflex)
::``;E::{U+00cb}       ; Backquote ; E               Ë (diaeresis)
::````I::{U+00cc}      ; Backquote Backquote I       Ì (grave)
::``,I::{U+00cd}       ; Backquote Comma I           Í (acute)
::``^I::{U+00ce}       ; Backquote ^ I               Î (circumflex)
::``6I::{U+00ce}       ; Backquote 6 I               Î (circumflex)
::``;I::{U+00cf}       ; Backquote ; I               Ï (diaeresis)
::``,D::{U+00d0}       ; Backquote Comma D           Ð (eth)
::``~N::{U+00d1}       ; Backquote Tilde N           Ñ (Spanish eñe)
::````O::{U+00d2}      ; Backquote Backquote O       Ò (grave)
::``,O::{U+00d3}       ; Backquote Comma O           Ó (acute)
::``^O::{U+00d4}       ; Backquote ^ O               Ô (circumflex)
::``6O::{U+00d4}       ; Backquote 6 O               Ô (circumflex)
::``~O::{U+00d5}       ; Backquote Tilde O           Õ (tilde)
::``;O::{U+00d6}       ; Backquote ; O               Ö (diaeresis)
::``/x::{U+00d7}       ; Backquote Slash x           × (multiplication)
::``/O::{U+00d8}       ; Backquote Slash O           Ø (O with stroke)
::````U::{U+00d9}      ; Backquote Backquote U       Ù (grave)
::``,U::{U+00da}       ; Backquote Comma U           Ú (acute)
::``^U::{U+00db}       ; Backquote ^ U               Û (circumflex)
::``6U::{U+00db}       ; Backquote ^ U               Û (circumflex)
::``;U::{U+00dc}       ; Backquote ; U               Ü (diaeresis)
::``,Y::{U+00dd}       ; Backquote Comma Y           Ý (acute)
::``,s::{U+00df}       ; Backquote Comma s           ß (eszette or sharp s)
::````a::{U+00e0}      ; Backquote Backquote a       à (grave)
::``,a::{U+00e1}       ; Backquote Comma a           á (acute)
::``^a::{U+00e2}       ; Backquote ^ a               â (circumflex)
::``6a::{U+00e2}       ; Backquote 6 a               â (circumflex)
::``~a::{U+00e3}       ; Backquote Tilde a           ã (tilde)
::``;a::{U+00e4}       ; Backquote ; a               ä (diaeresis)
::``@a::{U+00e5}       ; Backquote @ a               å (Aring)
::``2a::{U+00e5}       ; Backquote 2 a               å (Aring)
::``\a::{U+00e6}       ; Backquote Backslash a       æ (ligature)
::``,c::{U+00e7}       ; Backquote Comma c           ç (cedilla)
::````e::{U+00e8}      ; Backquote Backquote e       è (grave)
::``,e::{U+00e9}       ; Backquote Comma e           é (acute)
::``^e::{U+00ea}       ; Backquote ^ e               ê (circumflex)
::``6e::{U+00ea}       ; Backquote 6 e               ê (circumflex)
::``;e::{U+00eb}       ; Backquote ; e               ë (diaeresis)
::````i::{U+00ec}      ; Backquote Backquote i       ì (grave)
::``,i::{U+00ed}       ; Backquote Comma i           í (acute)
::``^i::{U+00ee}       ; Backquote ^ i               î (circumflex)
::``6i::{U+00ee}       ; Backquote 6 i               î (circumflex)
::``;i::{U+00ef}       ; Backquote ; i               ï (diaeresis)
::``,d::{U+00f0}       ; Backquote Comma d           ð (eth)
::``~n::{U+00f1}       ; Backquote Tilde n           ñ (Spanish eñe)
::````o::{U+00f2}      ; Backquote Backquote o       ò (grave)
::``,o::{U+00f3}       ; Backquote Comma o           ó (acute)
::``^o::{U+00f4}       ; Backquote ^ o               ô (circumflex)
::``6o::{U+00f4}       ; Backquote 6 o               ô (circumflex)
::``~o::{U+00f5}       ; Backquote Tilde o           õ (tilde)
::``;o::{U+00f6}       ; Backquote ; o               ö (diaeresis)
::``/d::{U+00f7}       ; Backquote Slash d           ÷ (division)
::``/o::{U+00f8}       ; Backquote Slash o           ø (o with stroke)
::````u::{U+00f9}      ; Backquote Backquote u       ù (grave)
::``,u::{U+00fa}       ; Backquote Comma u           ú (acute)
::``^u::{U+00fb}       ; Backquote 6 u               û (circumflex)
::``6u::{U+00fb}       ; Backquote 6 u               û (circumflex)
::``;u::{U+00fc}       ; Backquote ; u               ü (diaeresis)
::``,y::{U+00fd}       ; Backquote Comma y           ý (acute)
::``;y::{U+00ff}       ; Backquote ; y               ÿ (diaeresis)
::``_A::{U+0100}       ; Backquote Underscore A      Ā (macron)
::``_a::{U+0101}       ; Backquote Underscore a      ā (macron)
::``_E::{U+0112}       ; Backquote Underscore E      Ē (macron)
::``_e::{U+0113}       ; Backquote Underscore e      ē (macron)
::``_I::{U+012a}       ; Backquote Underscore I      Ī (macron)
::``_i::{U+012b}       ; Backquote Underscore i      ī (macron)
::``_O::{U+014c}       ; Backquote Underscore O      Ō (macron)
::``_o::{U+014d}       ; Backquote Underscore o      ō (macron)
::``\O::{U+0152}       ; Backquote Backslash O       Œ (ligature)
::``\o::{U+0153}       ; Backquote Backslash o       œ (ligature)
::``_U::{U+016a}       ; Backquote Underscore U      Ū (macron)
::``_u::{U+016b}       ; Backquote Underscore u      ū (macron)
::``;Y::{U+0178}       ; Backquote ; Y               Ÿ (diaeresis)
::``_Y::{U+0232}       ; Backquote Underscore Y      Ȳ (macron)
::``_y::{U+0233}       ; Backquote Underscore y      ȳ (macron)
::``_G::{U+1e20}       ; Backquote Underscore G      Ḡ (macron)
::``_g::{U+1e21}       ; Backquote Underscore g      ḡ (macron)
::``,=::{U+2013}       ; Backquote Comma Equals      – (en dash)
::``,-::{U+2014}       ; Backquote Comma Hyphen      — (em dash)
+'::send "{U+2018}"    ; Shift+Apostrophe            ‘ (single open quote)
'::send "{U+2019}"     ; Apostrophe                  ’ (single close quote)
::``^+"::{U+201C}      ; Backquote Ctrl+Shift+"      “ (double open quote)
::``^"::{U+201D}       ; Backquote Ctrl+"            ” (double close quote)
::``@d::{U+2020}       ; Backquote @ d               † (dagger)
::``2d::{U+2020}       ; Backquote 2 d               † (dagger)
::``@f::{U+2021}       ; Backquote Comma What        ‡ (double dagger)
::``2f::{U+2021}       ; Backquote Comma What        ‡ (double dagger)
::``@b::{U+2022}       ; Backquote @ b               • (bullet)
::``2b::{U+2022}       ; Backquote 2 b               • (bullet)
::``$[::{U+2039}       ; Backquote $ [               ‹ (single angle quote)
::``4[::{U+2039}       ; Backquote 4 [               ‹ (single angle quote)
::``$]::{U+203a}       ; Backquote $ ]               › (single angle quote)
::``4]::{U+203a}       ; Backquote 4 ]               › (single angle quote)
::``$e::{U+20AC}       ; Backquote $ e               € (euro)
::``4e::{U+20AC}       ; Backquote 4 e               € (euro)
::``@t::{U+2122}       ; Backquote @ t               ™ (unregistered trademark)
::``2t::{U+2122}       ; Backquote 2 t               ™ (unregistered trademark)
;